/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.DispatcherTracer;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.util.concurrent.TimeUnit;

public class OtherDispatcherTracer
extends DefaultTracer
implements DispatcherTracer {
    private final MetricNameFormat uri;

    public OtherDispatcherTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat uri) {
        super(transaction, sig, object, new SimpleMetricNameFormat("OtherTransaction/all"));
        this.uri = uri;
    }

    protected void doRecordMetrics(StatsEngine statsEngine, TransactionData transactionData) {
        super.doRecordMetrics(statsEngine, transactionData);
        String blameMetricName = transactionData.getBlameMetricName();
        String uriMetricName = this.uri.getMetricName();
        String dispatcherMetricName = uriMetricName.equals(blameMetricName) ? uriMetricName : blameMetricName;
        statsEngine.getResponseTimeStats(dispatcherMetricName).recordResponseTime(this.getDuration(), this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
    }

    public String getDispatcherUri() {
        return this.uri.getMetricName();
    }
}

