/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.AbstractTracer;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodExitTracerNoSkip
extends AbstractTracer {
    private ClassMethodSignature signature;
    private final Transaction transaction;

    protected abstract void doFinish(int var1, Object var2);

    public MethodExitTracerNoSkip(ClassMethodSignature signature) {
        this.signature = signature;
        this.transaction = null;
    }

    public MethodExitTracerNoSkip(ClassMethodSignature signature, Transaction transaction) {
        this.signature = signature;
        this.transaction = transaction;
    }

    protected Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void childTracerFinished(Tracer child) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void finish(int opcode, Object returnValue) {
        try {
            this.doFinish(opcode, returnValue);
        }
        finally {
            this.signature = null;
            if (this.transaction != null) {
                this.transaction.tracerFinished(this, opcode);
            }
        }
    }

    @Override
    public void finish(Throwable throwable) {
    }

    @Override
    public final Collection<Tracer> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public final ClassMethodSignature getClassMethodSignature() {
        return this.signature;
    }

    @Override
    public final long getDurationInMilliseconds() {
        return 0L;
    }

    @Override
    public final long getDuration() {
        return 0L;
    }

    @Override
    public final long getExclusiveDuration() {
        return 0L;
    }

    @Override
    public final long getStartTime() {
        return 0L;
    }

    @Override
    public final long getStartTimeInMilliseconds() {
        return 0L;
    }

    @Override
    public final long getEndTime() {
        return 0L;
    }

    @Override
    public final long getEndTimeInMilliseconds() {
        return 0L;
    }

    @Override
    public final String getMetricName() {
        return null;
    }

    @Override
    public String getTransactionSegmentName() {
        return null;
    }

    @Override
    public final Map<String, Object> getParameters() {
        return Collections.emptyMap();
    }

    @Override
    public final Throwable getThrowable() {
        return null;
    }

    @Override
    public final boolean isTransactionSegment() {
        return false;
    }

    @Override
    public final void recordMetrics(StatsEngine statsEngine, TransactionData transactionData) {
    }

    @Override
    public final boolean isMetricProducer() {
        return false;
    }

    @Override
    public final TransactionSegment getTransactionSegment(SqlObfuscator sqlObfuscator, long startTime, TransactionSegment lastSibling) {
        return new TransactionSegment(sqlObfuscator, startTime, this);
    }
}

