/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

public class ClassMethodSignature {
    private final String className;
    private final String methodName;
    private final String methodDesc;

    public ClassMethodSignature(String className, String methodName, String methodDesc) {
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
    }

    public String getClassName() {
        return this.className;
    }

    public String getInternalClassName() {
        return this.className.replace('.', '/');
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodDesc() {
        return this.methodDesc;
    }

    public String toString() {
        return this.className + '.' + this.methodName + this.methodDesc;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.methodDesc == null ? 0 : this.methodDesc.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassMethodSignature other = (ClassMethodSignature)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.methodDesc == null ? other.methodDesc != null : !this.methodDesc.equals(other.methodDesc)) {
            return false;
        }
        return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
    }
}

