/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.AgentWrapper;
import com.newrelic.agent.tracers.Tracer;
import java.lang.reflect.Method;
import java.util.logging.Level;

public abstract class AbstractTracer
implements Tracer {
    public final Object invoke(Object methodName, Method method, Object[] args) {
        try {
            if (args == null) {
                Agent.LOG.severe("Tracer.finish() was invoked with no arguments");
            } else if (AgentWrapper.SUCCESSFUL_METHOD_INVOCATION == methodName) {
                if (args.length == 2) {
                    this.finish((Integer)args[0], args[1]);
                } else {
                    Agent.LOG.log(Level.SEVERE, "Tracer.finish(int, Object) was invoked with {0} arguments(s)", args.length);
                }
            } else if (AgentWrapper.UNSUCCESSFUL_METHOD_INVOCATION == methodName) {
                if (args.length == 1) {
                    this.finish((Throwable)args[0]);
                } else {
                    Agent.LOG.log(Level.SEVERE, "Tracer.finish(Throwable) was invoked with {0} arguments(s)", args.length);
                }
            } else {
                Agent.LOG.log(Level.SEVERE, "Tracer.finish was invoked with an unknown method: {0}", methodName);
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.SEVERE, "An error occurred finishing method tracer {0} : {1}", new Object[]{this.getClass().getName(), t.getMessage()});
            Agent.LOG.log(Level.FINE, "An error occurred finishing method tracer for signature : {0}", new Object[]{this.getClassMethodSignature()});
            Agent.LOG.log(Level.FINER, t.getMessage(), t);
        }
        return null;
    }
}

