/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.trace.TransactionTrace;
import com.newrelic.agent.trace.TransactionTraceBucket;
import com.newrelic.agent.tracers.RequestDispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionTraceService
extends AbstractService
implements HarvestListener {
    private volatile boolean enabled = false;
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final ConcurrentMap<String, TransactionTraceBucket> transactionTraceBuckets = new ConcurrentHashMap<String, TransactionTraceBucket>();
    private final boolean autoAppNameEnabled;

    public TransactionTraceService() {
        super(TransactionTraceService.class.getSimpleName());
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        this.enabled = config.getTransactionTracerConfig().isEnabled();
        this.autoAppNameEnabled = config.isAutoAppNamingEnabled();
    }

    public ThreadMXBean getThreadMXBean() {
        return this.threadMXBean;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        TransactionTracerConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().getTransactionTracerConfig();
        this.enabled = config.isEnabled() && enabled;
    }

    private TransactionTraceBucket getTransactionTraceBucket(TransactionData transactionData) {
        if (this.autoAppNameEnabled) {
            return this.getOrCreateTransactionTraceBucket(transactionData.getApplicationName());
        }
        return this.getTransactionBucket(transactionData.getRootTracer());
    }

    private TransactionTraceBucket getOrCreateTransactionTraceBucket(String appName) {
        TransactionTraceBucket oldBucket;
        TransactionTraceBucket bucket = this.getTransactionTraceBucket(appName);
        if (bucket == null && (oldBucket = this.transactionTraceBuckets.putIfAbsent(appName, bucket = this.createBucket(appName))) != null) {
            return oldBucket;
        }
        return bucket;
    }

    private TransactionTraceBucket getTransactionTraceBucket(String bucketName) {
        return (TransactionTraceBucket)this.transactionTraceBuckets.get(bucketName);
    }

    private String getTransactionBucketName(Tracer tracer) {
        return tracer instanceof RequestDispatcherTracer ? "request" : "background";
    }

    public TransactionTracerConfig getTransactionTraceConfig(Tracer tracer) {
        String bucketName = this.getTransactionBucketName(tracer);
        return ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().getTransactionTracerConfig(bucketName);
    }

    private void noticeTransaction(TransactionData transactionData) {
        TransactionTraceBucket bucket;
        if (this.enabled && (bucket = this.getTransactionTraceBucket(transactionData)) != null) {
            bucket.noticeTransaction(transactionData);
        }
    }

    private TransactionTraceBucket getTransactionBucket(Tracer tracer) {
        TransactionTraceBucket bucket = this.getTransactionTraceBucket(this.getTransactionBucketName(tracer));
        if (bucket == null) {
            bucket = this.getTransactionTraceBucket("request");
        }
        return bucket;
    }

    @Override
    public void beforeHarvest(IRPMService rpmService) {
    }

    @Override
    public void afterHarvest(IRPMService rpmService) {
        if (!this.isEnabled()) {
            return;
        }
        List<TransactionTrace> traces = this.autoAppNameEnabled ? this.getExpensiveTransaction(rpmService.getApplicationName()) : this.getAllExpensiveTransactions();
        if (!traces.isEmpty()) {
            this.sendTraces(rpmService, traces);
        }
    }

    private List<TransactionTrace> getAllExpensiveTransactions() {
        ArrayList<TransactionTrace> traces = new ArrayList<TransactionTrace>();
        for (TransactionTraceBucket bucket : this.transactionTraceBuckets.values()) {
            TransactionTrace expensiveTransaction = bucket.getAndResetExpensiveTransaction();
            if (expensiveTransaction == null) continue;
            traces.add(expensiveTransaction);
        }
        return traces;
    }

    public List<TransactionTrace> getExpensiveTransaction(String appName) {
        TransactionTrace expensiveTransaction;
        ArrayList<TransactionTrace> traces = new ArrayList<TransactionTrace>();
        TransactionTraceBucket bucket = this.getTransactionTraceBucket(appName);
        if (bucket != null && (expensiveTransaction = bucket.getAndResetExpensiveTransaction()) != null) {
            traces.add(expensiveTransaction);
        }
        return traces;
    }

    private void sendTraces(IRPMService rpmService, Collection<TransactionTrace> traceList) {
        block5: {
            if (!rpmService.isConnected()) {
                return;
            }
            try {
                rpmService.sendTransactionTraceData(traceList);
            }
            catch (IgnoreSilentlyException e) {
            }
            catch (Exception e) {
                if (!this.getLogger().isLoggable(Level.FINER)) break block5;
                String msg = MessageFormat.format("Error sending transaction trace data to {0} for {1}: {2}", rpmService.getHostString(), rpmService.getApplicationName(), e.getMessage());
                if (this.getLogger().isLoggable(Level.FINEST)) {
                    this.getLogger().log(Level.FINEST, msg, e);
                }
                this.getLogger().finer(msg);
            }
        }
    }

    @Override
    protected void doStart() {
        if (!this.autoAppNameEnabled) {
            this.createBuckets();
        }
        ServiceManagerFactory.getServiceManager().getTransactionService().addTransactionListener(new TraceListener());
        ServiceManagerFactory.getServiceManager().getHarvestService().addHarvestListener(this);
    }

    @Override
    protected void doStop() {
        for (TransactionTraceBucket bucket : this.transactionTraceBuckets.values()) {
            bucket.getAndResetExpensiveTransaction();
        }
        this.transactionTraceBuckets.clear();
    }

    private void createBuckets() {
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        Map<String, TransactionTracerConfig> configs = config.getTransactionTracerConfigCategories();
        for (Map.Entry<String, TransactionTracerConfig> entry : configs.entrySet()) {
            this.transactionTraceBuckets.put(entry.getKey(), new TransactionTraceBucket(this.getLogger(), this.enabled && entry.getValue().isEnabled()));
        }
    }

    private TransactionTraceBucket createBucket(String appName) {
        return new TransactionTraceBucket(this.getLogger(), this.enabled);
    }

    private class TraceListener
    implements TransactionListener {
        private TraceListener() {
        }

        public void dispatcherTransactionFinished(TransactionData transactionData) {
            if (transactionData.getResponseStatus() < 400 && !transactionData.isTraceDisabled()) {
                TransactionTraceService.this.noticeTransaction(transactionData);
            }
        }
    }
}

