/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.StackTraces;
import com.newrelic.org.json.simple.JSONArray;
import com.newrelic.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionSegment
implements JSONStreamAware {
    private static final Pattern INSERT_INTO_VALUES_STATEMENT = Pattern.compile("\\s*insert\\s+into\\s+([^\\s(,]*)\\s+values.*", 2);
    private String metricName;
    private final List<TransactionSegment> children;
    private final long entryTimestamp;
    private long exitTimestamp;
    private final Map<String, Object> tracerParameters;
    private int callCount = 1;
    private final SqlObfuscator sqlObfuscator;

    public TransactionSegment(SqlObfuscator sqlObfuscator, long startTime, Tracer tracer) {
        this(sqlObfuscator, startTime, tracer, null);
    }

    TransactionSegment(SqlObfuscator sqlObfuscator, long startTime, Tracer tracer, TransactionSegment childSegment) {
        this.sqlObfuscator = sqlObfuscator;
        this.metricName = TransactionSegment.getMetricName(tracer);
        if (childSegment == null) {
            int childCount = tracer.getChildren().size();
            this.children = childCount == 0 ? Collections.EMPTY_LIST : new ArrayList(childCount);
        } else {
            this.children = new ArrayList<TransactionSegment>(1);
            this.children.add(childSegment);
        }
        this.entryTimestamp = tracer.getStartTimeInMilliseconds() - startTime;
        this.exitTimestamp = tracer.getEndTimeInMilliseconds() - startTime;
        this.tracerParameters = tracer.getParameters();
    }

    private static String getMetricName(Tracer tracer) {
        String metricName = tracer.getTransactionSegmentName();
        if (metricName == null || metricName.trim().length() == 0) {
            if (Agent.isDebugEnabled()) {
                throw new RuntimeException(MessageFormat.format("Encountered a transaction segment with an invalid metric name. {0}", tracer.getClass().getName()));
            }
            metricName = tracer.getClass().getName() + "*";
        }
        return metricName;
    }

    void setMetricName(String name) {
        this.metricName = name;
    }

    public Collection<TransactionSegment> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void addChild(TransactionSegment sample) {
        try {
            this.children.add(sample);
        }
        catch (UnsupportedOperationException e) {
            Agent.LOG.log(Level.INFO, "Unable to add transaction segment {0} to parent segment {1}", new Object[]{sample, this});
        }
    }

    public String toString() {
        return this.metricName;
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>(this.tracerParameters);
        this.processSqlParams(params);
        if (this.callCount > 0) {
            params.put("call_count", this.callCount);
        }
        JSONArray.writeJSONString(Arrays.asList(this.entryTimestamp, this.exitTimestamp, this.metricName, params, this.children), writer);
    }

    private void processSqlParams(Map<String, Object> params) {
        String sql;
        List backtrace = (List)params.remove("backtrace");
        if (backtrace != null) {
            List<StackTraceElement> stackTraces = StackTraces.scrubAndTruncate(backtrace);
            params.put("backtrace", StackTraces.toStringList(stackTraces));
        }
        if ((sql = (String)params.remove("sql")) == null) {
            return;
        }
        if ((sql = this.sqlObfuscator.obfuscateSql(sql)) == null) {
            return;
        }
        TransactionTracerConfig tracerConfig = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().getTransactionTracerConfig();
        if (INSERT_INTO_VALUES_STATEMENT.matcher(sql).matches()) {
            int maxLength = tracerConfig.getInsertSqlMaxLength();
            sql = TransactionSegment.truncateSql(sql, maxLength);
        }
        if (tracerConfig.isLogSql()) {
            Agent.LOG.log(Level.INFO, MessageFormat.format("{0} SQL: {1}", tracerConfig.getRecordSql(), sql));
            return;
        }
        params.put(this.sqlObfuscator.isObfuscating() ? "sql_obfuscated" : "sql", sql);
    }

    public void merge(Tracer tracer) {
        ++this.callCount;
        this.exitTimestamp += tracer.getDurationInMilliseconds();
    }

    public static String truncateSql(String sql, int maxLength) {
        int len = sql.length();
        if (len > maxLength) {
            return MessageFormat.format("{0}..({1} more chars)", sql.substring(0, maxLength), len - maxLength);
        }
        return sql;
    }
}

