/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.MetricData;
import com.newrelic.agent.MetricSpec;
import com.newrelic.agent.stats.ApdexStats;
import com.newrelic.agent.stats.ApdexStatsImpl;
import com.newrelic.agent.stats.MonotonicallyIncreasingStats;
import com.newrelic.agent.stats.ResponseTimeStats;
import com.newrelic.agent.stats.ResponseTimeStatsImpl;
import com.newrelic.agent.stats.Stats;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsImpl;
import com.newrelic.agent.util.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatsEngineImpl
implements StatsEngine {
    private final List<MetricData> pendingMetricData;
    private final Map<MetricSpec, StatsBase> stats = new HashMap<MetricSpec, StatsBase>(140);
    private final Map<MetricSpec, MonotonicallyIncreasingStats> monoStats = new HashMap<MetricSpec, MonotonicallyIncreasingStats>(140);
    private volatile boolean wrapNumbersForSerialization = true;

    public StatsEngineImpl() {
        this.pendingMetricData = new LinkedList<MetricData>();
    }

    @Override
    public Stats getStats(String name) {
        return this.getStats(MetricSpec.lookup(name, null));
    }

    @Override
    public MonotonicallyIncreasingStats getMonotonicallyIncreasingStats(String metricName) {
        if (metricName == null) {
            throw new RuntimeException("Cannot get a stat for a null metric");
        }
        MetricSpec metric = MetricSpec.lookup(metricName);
        MonotonicallyIncreasingStats s = this.monoStats.get(metric);
        try {
            if (s == null) {
                s = new MonotonicallyIncreasingStats(this);
                this.monoStats.put(metric, s);
                MonotonicallyIncreasingStats monotonicallyIncreasingStats = s;
                return monotonicallyIncreasingStats;
            }
            if (s instanceof MonotonicallyIncreasingStats) {
                MonotonicallyIncreasingStats monotonicallyIncreasingStats = s;
                return monotonicallyIncreasingStats;
            }
            throw new RuntimeException("The stats object for " + metric + " is of type " + s.getClass().getName() + ", not MonotonicallyIncreasingStats");
        }
        finally {
            if (s != null) {
                this.stats.put(metric, s);
            }
        }
    }

    @Override
    public ResponseTimeStats getResponseTimeStats(String name) {
        return this.getResponseTimeStats(MetricSpec.lookup(name, null));
    }

    @Override
    public Object getHarvestLock() {
        return this;
    }

    @Override
    public synchronized Stats getStats(MetricSpec metric) {
        if (metric == null) {
            throw new RuntimeException("Cannot get a stat for a null metric");
        }
        StatsBase s = this.stats.get(metric);
        if (s == null) {
            s = new StatsImpl(this);
            this.stats.put(metric, s);
            return (StatsImpl)s;
        }
        if (s instanceof Stats) {
            return (Stats)s;
        }
        throw new RuntimeException("The stats object for " + metric + " is of type " + s.getClass().getName());
    }

    @Override
    public synchronized ResponseTimeStats getResponseTimeStats(MetricSpec metric) {
        if (metric == null) {
            throw new RuntimeException("Cannot get a stat for a null metric");
        }
        StatsBase s = this.stats.get(metric);
        if (s == null) {
            s = new ResponseTimeStatsImpl(this);
            this.stats.put(metric, s);
            return (ResponseTimeStatsImpl)s;
        }
        if (s instanceof ResponseTimeStats) {
            return (ResponseTimeStatsImpl)s;
        }
        throw new RuntimeException("The stats object for " + metric + " is of type " + s.getClass().getName());
    }

    @Override
    public synchronized ApdexStats getApdexStats(MetricSpec metric, long apdexT) {
        if (metric == null) {
            throw new RuntimeException("Cannot get a stat for a null metric");
        }
        StatsBase s = this.stats.get(metric);
        if (s == null) {
            s = new ApdexStatsImpl(this.getHarvestLock(), apdexT);
            this.stats.put(metric, s);
            return (ApdexStatsImpl)s;
        }
        if (s instanceof ApdexStats) {
            return (ApdexStats)s;
        }
        throw new RuntimeException("The stats object for " + metric + " is of type " + s.getClass().getName());
    }

    @Override
    public synchronized List<MetricData> harvest() {
        for (MetricData data : this.pendingMetricData) {
            StatsBase currentStats = this.stats.get(data.getMetricSpec());
            if (currentStats == null) {
                this.stats.put(data.getMetricSpec(), data.getStats());
                continue;
            }
            currentStats.merge(data.getStats());
        }
        ArrayList<MetricData> list = new ArrayList<MetricData>(this.stats.size());
        for (Map.Entry<MetricSpec, StatsBase> metricStats : this.stats.entrySet()) {
            if (!metricStats.getValue().hasData()) continue;
            list.add(new MetricData(metricStats.getKey(), metricStats.getValue()));
        }
        this.pendingMetricData.clear();
        this.pendingMetricData.addAll(list);
        this.resetStats();
        return list;
    }

    @Override
    public synchronized void clear() {
        this.pendingMetricData.clear();
        this.stats.clear();
    }

    public synchronized int getSize() {
        return this.stats.size();
    }

    @Override
    public synchronized void resetStats() {
        this.stats.clear();
    }

    @Override
    public synchronized void clearPendingMetricData() {
        this.pendingMetricData.clear();
        for (MonotonicallyIncreasingStats stat : this.monoStats.values()) {
            stat.reset();
        }
    }

    public void setWrapNumbersForSerialization(boolean wrapNumbersForSerialization) {
        this.wrapNumbersForSerialization = wrapNumbersForSerialization;
    }

    @Override
    public Number serializeNumber(Number number) {
        return this.wrapNumbersForSerialization ? (Number)JSON.serializeNumber(number) : (Number)number;
    }
}

