/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.stats.AbstractStats;
import com.newrelic.agent.stats.ResponseTimeStats;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.agent.stats.StatsEngine;
import java.util.concurrent.TimeUnit;

public class ResponseTimeStatsImpl
extends AbstractStats
implements ResponseTimeStats {
    private static final long NANOSECONDS_PER_SECOND_SQUARED = 1000000000000000000L;
    private long total;
    private long totalExclusive;
    private long minValue;
    private long maxValue;
    private double sumOfSquares;

    ResponseTimeStatsImpl(StatsEngine statsEngine) {
        super(statsEngine);
    }

    protected Object clone() throws CloneNotSupportedException {
        ResponseTimeStatsImpl newStats = new ResponseTimeStatsImpl(this.statsEngine);
        newStats.count = this.count;
        newStats.total = this.total;
        newStats.totalExclusive = this.totalExclusive;
        newStats.minValue = this.minValue;
        newStats.maxValue = this.maxValue;
        newStats.sumOfSquares = this.sumOfSquares;
        return newStats;
    }

    public void recordResponseTime(long responseTime, TimeUnit timeUnit) {
        long responseTimeInNanos = TimeUnit.NANOSECONDS.convert(responseTime, timeUnit);
        this.recordResponseTimeInNanos(responseTimeInNanos, responseTimeInNanos);
    }

    public void recordResponseTime(long responseTime, long exclusiveTime, TimeUnit timeUnit) {
        long responseTimeInNanos = TimeUnit.NANOSECONDS.convert(responseTime, timeUnit);
        long exclusiveTimeInNanos = TimeUnit.NANOSECONDS.convert(exclusiveTime, timeUnit);
        this.recordResponseTimeInNanos(responseTimeInNanos, exclusiveTimeInNanos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordResponseTimeInNanos(long responseTime, long exclusiveTime) {
        Object object = this.lock;
        synchronized (object) {
            double responseTimeAsDouble = new Long(responseTime).doubleValue();
            responseTimeAsDouble *= responseTimeAsDouble;
            this.sumOfSquares += responseTimeAsDouble;
            this.minValue = this.count > 0 ? Math.min(responseTime, this.minValue) : responseTime;
            ++this.count;
            this.total += responseTime;
            this.maxValue = Math.max(responseTime, this.maxValue);
            this.totalExclusive += exclusiveTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasData() {
        Object object = this.lock;
        synchronized (object) {
            return this.count > 0 || this.total > 0L || this.totalExclusive > 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.count = 0;
            this.maxValue = 0L;
            this.minValue = 0L;
            this.totalExclusive = 0L;
            this.total = 0L;
            this.sumOfSquares = 0.0;
        }
    }

    public float getTotal() {
        return (float)this.total / 1.0E9f;
    }

    public float getTotalExclusiveTime() {
        return (float)this.totalExclusive / 1.0E9f;
    }

    public float getMaxCallTime() {
        return (float)this.maxValue / 1.0E9f;
    }

    public float getMinCallTime() {
        return (float)this.minValue / 1.0E9f;
    }

    public double getSumOfSquares() {
        return this.sumOfSquares / 1.0E18;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void merge(StatsBase statsObj) {
        if (statsObj instanceof ResponseTimeStatsImpl) {
            ResponseTimeStatsImpl stats = (ResponseTimeStatsImpl)statsObj;
            Object object = this.lock;
            synchronized (object) {
                if (stats.count > 0) {
                    this.minValue = this.count > 0 ? Math.min(this.minValue, stats.minValue) : stats.minValue;
                }
                this.count += stats.count;
                this.total += stats.total;
                this.totalExclusive += stats.totalExclusive;
                this.maxValue = Math.max(this.maxValue, stats.maxValue);
                this.sumOfSquares += stats.sumOfSquares;
            }
        }
    }
}

