/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.stats.CountStats;
import com.newrelic.agent.stats.InvalidStatsException;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.org.json.simple.JSONArray;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractStats
implements CountStats {
    private static final List<Number> ZERO_ARRAY_LIST;
    protected int count;
    protected final Object lock;
    protected final StatsEngine statsEngine;
    public static final StatsBase EMPTY_STATS;

    public AbstractStats(StatsEngine statsEngine) {
        this.statsEngine = statsEngine;
        this.lock = statsEngine.getHarvestLock();
    }

    public AbstractStats(int count) {
        this.count = count;
        this.lock = null;
        this.statsEngine = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCallCount(int value) {
        Object object = this.lock;
        synchronized (object) {
            this.count += value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCallCount() {
        Object object = this.lock;
        synchronized (object) {
            ++this.count;
        }
    }

    public int getCallCount() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallCount(int count) {
        Object object = this.lock;
        synchronized (object) {
            this.count = count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.count >= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeJSONString(Writer writer) throws IOException, InvalidStatsException {
        List<Number> list;
        Object object = this.lock;
        synchronized (object) {
            list = this.count < 0 ? ZERO_ARRAY_LIST : Arrays.asList(this.count, this.statsEngine.serializeNumber(Float.valueOf(this.getTotal())), this.statsEngine.serializeNumber(Float.valueOf(this.getTotalExclusiveTime())), this.statsEngine.serializeNumber(Float.valueOf(this.getMinCallTime())), this.statsEngine.serializeNumber(Float.valueOf(this.getMaxCallTime())), this.statsEngine.serializeNumber(this.getSumOfSquares()));
        }
        JSONArray.writeJSONString(list, writer);
    }

    static {
        Integer zero = 0;
        ZERO_ARRAY_LIST = Arrays.asList(zero, zero, zero, zero, zero, zero);
        EMPTY_STATS = new StatsBase(){

            public boolean hasData() {
                return true;
            }

            public void merge(StatsBase stats) {
            }

            public void reset() {
            }

            public void writeJSONString(Writer writer) throws IOException {
                JSONArray.writeJSONString(ZERO_ARRAY_LIST, writer);
            }

            public boolean isValid() {
                return true;
            }
        };
    }
}

