/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.session;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.stats.Stats;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.util.CleverClassLoader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class SessionService
implements HarvestListener {
    private int sessionCount = 0;
    private boolean enabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(Object session) {
        SessionService sessionService = this;
        synchronized (sessionService) {
            ++this.sessionCount;
        }
        if (Agent.isDebugEnabled()) {
            Agent.LOG.fine("Session created.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(Object session) {
        SessionService sessionService = this;
        synchronized (sessionService) {
            --this.sessionCount;
        }
        if (Agent.isDebugEnabled()) {
            Agent.LOG.fine("Session destroyed");
        }
    }

    public synchronized int getSessionCount() {
        return this.sessionCount;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void afterHarvest(IRPMService rpmService) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeHarvest(IRPMService rpmService) {
        if (ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().isSessionCountTrackingEnabled()) {
            StatsEngine statsEngine = rpmService.getStatsEngine();
            Object object = statsEngine.getHarvestLock();
            synchronized (object) {
                Stats sessionStats = statsEngine.getStats("Sessions");
                sessionStats.setCallCount(this.getSessionCount());
            }
        }
    }

    public Object createListener(ClassLoader classLoader) throws ClassNotFoundException, IOException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        CleverClassLoader cl = new CleverClassLoader(classLoader);
        Class listenerClazz = cl.loadClassSpecial("com.newrelic.agent.session.SessionListener");
        return listenerClazz.getConstructor(SessionService.class).newInstance(this);
    }
}

