/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.session;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class SessionInfo {
    private final Object session;
    private Method getAttributeNamesMethod;
    private Method getAttributeMethod;
    private long objectSize;

    public SessionInfo(Object session) {
        this.session = session;
        try {
            this.getAttributeNamesMethod = session.getClass().getMethod("getAttributeNames", new Class[0]);
            this.getAttributeMethod = session.getClass().getMethod("getAttribute", String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    Object[] getAttributes() {
        if (this.getAttributeMethod == null || this.getAttributeNamesMethod == null) {
            return new Object[0];
        }
        ArrayList<Object> attrs = new ArrayList<Object>();
        try {
            Enumeration en = (Enumeration)this.getAttributeNamesMethod.invoke(this.session, new Object[0]);
            for (Object attr : Collections.list(en)) {
                String name = (String)attr;
                Object obj = this.getAttributeMethod.invoke(this.session, name);
                attrs.add(obj);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return attrs.toArray();
    }

    void setObjectSize(long objectSize) {
        this.objectSize = objectSize;
    }

    public long getObjectSize() {
        return this.objectSize;
    }

    public Object getSession() {
        return this.session;
    }
}

