/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.samplers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.security.AccessControlException;
import java.util.List;

public class ThreadSampler
implements MetricSampler {
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample() {
        long[] deadlockedThreadIds;
        int threadCount = this.threadMXBean.getThreadCount();
        try {
            deadlockedThreadIds = this.threadMXBean.findMonitorDeadlockedThreads();
        }
        catch (AccessControlException e) {
            Agent.LOG.finer("An error occurred calling ThreadMXBean.findMonitorDeadlockedThreads: " + e.getMessage());
            deadlockedThreadIds = new long[]{};
        }
        int deadlockCount = deadlockedThreadIds == null ? 0 : deadlockedThreadIds.length;
        List<IRPMService> rpmServices = ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMServices();
        for (IRPMService rpmService : rpmServices) {
            StatsEngine engine = rpmService.getStatsEngine();
            Object object = engine.getHarvestLock();
            synchronized (object) {
                engine.getStats("Threads/all").setCallCount(threadCount);
                engine.getStats("Threads/Deadlocks/all").setCallCount(deadlockCount);
            }
        }
    }
}

