/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.samplers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class MemorySampler
implements MetricSampler,
HarvestListener {
    public static final float BYTES_PER_MB = 1048576.0f;
    private final MemoryMXBean memoryMXBean;
    private final AtomicBoolean hasSampled = new AtomicBoolean();

    public MemorySampler() {
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
    }

    void start() {
        ServiceManagerFactory.getServiceManager().getHarvestService().addHarvestListener(this);
    }

    public void beforeHarvest(IRPMService rpmService) {
        if (!this.hasSampled.get()) {
            this.sample();
        }
    }

    public void afterHarvest(IRPMService rpmService) {
        this.hasSampled.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sample() {
        MemoryUsage heapMemoryUsage = this.memoryMXBean.getHeapMemoryUsage();
        long nonHeapCommitted = 0L;
        long nonHeapUsed = 0L;
        long nonHeapMemoryMax = 0L;
        try {
            MemoryUsage nonHeapMemoryUsage = this.memoryMXBean.getNonHeapMemoryUsage();
            nonHeapCommitted = nonHeapMemoryUsage.getCommitted();
            nonHeapUsed = nonHeapMemoryUsage.getUsed();
            nonHeapMemoryMax = nonHeapMemoryUsage.getMax();
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "Memory sampler error", e);
        }
        List<IRPMService> rpmServices = ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMServices();
        Iterator<IRPMService> i$ = rpmServices.iterator();
        while (i$.hasNext()) {
            IRPMService rpmService = i$.next();
            StatsEngine engine = rpmService.getStatsEngine();
            Object object = engine.getHarvestLock();
            synchronized (object) {
                engine.getStats("Memory/Physical").recordDataPoint((float)(nonHeapCommitted + heapMemoryUsage.getCommitted()) / 1048576.0f);
                engine.getStats("Memory/Used").recordDataPoint((float)(nonHeapUsed + heapMemoryUsage.getUsed()) / 1048576.0f);
                engine.getStats("Memory/Heap/Used").recordDataPoint((float)heapMemoryUsage.getUsed() / 1048576.0f);
                engine.getStats("Memory/Heap/Committed").recordDataPoint((float)heapMemoryUsage.getCommitted() / 1048576.0f);
                engine.getStats("Memory/Heap/Max").recordDataPoint((float)heapMemoryUsage.getMax() / 1048576.0f);
                engine.getStats("Memory/NonHeap/Used").recordDataPoint((float)nonHeapUsed / 1048576.0f);
                engine.getStats("Memory/NonHeap/Committed").recordDataPoint((float)nonHeapCommitted / 1048576.0f);
                engine.getStats("Memory/NonHeap/Max").recordDataPoint((float)nonHeapMemoryMax / 1048576.0f);
            }
            try {
                List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
                for (MemoryPoolMXBean mp : memoryPoolMXBeans) {
                    float usage = (float)mp.getUsage().getUsed() / 1048576.0f;
                    float committed = (float)mp.getUsage().getCommitted() / 1048576.0f;
                    float max = (float)mp.getUsage().getMax() / 1048576.0f;
                    Object object2 = engine.getHarvestLock();
                    synchronized (object2) {
                        engine.getStats(MemorySampler.getMemoryPoolMetricName(mp, "MemoryPool/{0}/{1}/Used")).recordDataPoint(usage);
                        engine.getStats(MemorySampler.getMemoryPoolMetricName(mp, "MemoryPool/{0}/{1}/Committed")).recordDataPoint(committed);
                        engine.getStats(MemorySampler.getMemoryPoolMetricName(mp, "MemoryPool/{0}/{1}/Max")).recordDataPoint(max);
                    }
                }
            }
            catch (Exception e) {
                Agent.LOG.log(Level.INFO, "An error occurred gathering memory pool metrics : {0}", e.toString());
                Agent.LOG.log(Level.FINER, "Memory sampler error", e);
            }
            this.hasSampled.set(true);
        }
        return;
    }

    public static String getMemoryPoolMetricName(MemoryPoolMXBean mp, String mask) {
        String name = mp.getName();
        String type = mp.getType() == MemoryType.HEAP ? "Heap" : "Non-Heap";
        return MessageFormat.format(mask, type, name);
    }
}

