/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.rpm;

import com.newrelic.agent.Environment;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.rpm.RPMConnectionService;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.util.DefaultThreadFactory;
import java.text.MessageFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class RPMConnectionServiceImpl
extends AbstractService
implements RPMConnectionService {
    public static final String RPM_CONNECTION_THREAD_NAME = "New Relic RPM Connection Service";
    public static final long INITIAL_APP_SERVER_PORT_DELAY = 5L;
    public static final long SUBSEQUENT_APP_SERVER_PORT_DELAY = 5L;
    public static final long APP_SERVER_PORT_TIMEOUT = 120L;
    public static final long CONNECT_ATTEMPT_INTERVAL = 60L;
    private static final int MAX_LOGGED_CONNECT_ATTEMPT_COUNT = 5;
    private final ScheduledExecutorService scheduledExecutor;

    public RPMConnectionServiceImpl() {
        super(RPMConnectionService.class.getSimpleName());
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(RPM_CONNECTION_THREAD_NAME, true);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    protected void doStart() {
    }

    protected void doStop() {
        this.scheduledExecutor.shutdown();
    }

    public void connect(IRPMService rpmService) {
        RPMConnectionTask connectionTask = new RPMConnectionTask(rpmService);
        connectionTask.start();
    }

    public void connectImmediate(IRPMService rpmService) {
        RPMConnectionTask connectionTask = new RPMConnectionTask(rpmService);
        connectionTask.startImmediate();
    }

    public boolean isEnabled() {
        return true;
    }

    public long getInitialAppServerPortDelay() {
        return 5L;
    }

    public long getAppServerPortTimeout() {
        return 120L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RPMConnectionTask
    implements Runnable {
        private final IRPMService rpmService;
        private final AtomicReference<ScheduledFuture<?>> appServerPortTask = new AtomicReference();
        private final AtomicReference<ScheduledFuture<?>> appServerPortTimeoutTask = new AtomicReference();
        private final AtomicReference<ScheduledFuture<?>> connectTask = new AtomicReference();
        private final AtomicInteger attemptCount = new AtomicInteger();
        private final AtomicBoolean connectTaskStarted = new AtomicBoolean();

        private RPMConnectionTask(IRPMService rpmService) {
            this.rpmService = rpmService;
        }

        @Override
        public void run() {
        }

        private void start() {
            if (!this.rpmService.isMainApp()) {
                this.startImmediate();
            } else if (this.isSyncStartup()) {
                RPMConnectionServiceImpl.this.getLogger().log(Level.FINER, "Not waiting for application server port");
                this.startSync();
            } else {
                RPMConnectionServiceImpl.this.getLogger().log(Level.FINER, "Waiting for application server port");
                this.appServerPortTask.set(this.scheduleAppServerPortTask());
                this.appServerPortTimeoutTask.set(this.scheduleAppServerPortTimeoutTask());
            }
        }

        private void startSync() {
            if (this.isConnected() || this.attemptConnection()) {
                return;
            }
            this.startImmediate();
        }

        private void startImmediate() {
            this.connectTask.set(this.scheduleConnectTask());
        }

        private void stop() {
            RPMConnectionServiceImpl.this.getLogger().log(Level.FINER, "Stopping RPM connection task for {0}", this.rpmService.getApplicationName());
            ScheduledFuture<?> handle = this.appServerPortTask.get();
            if (handle != null) {
                handle.cancel(false);
            }
            if ((handle = this.connectTask.get()) != null) {
                handle.cancel(false);
            }
            if ((handle = this.appServerPortTimeoutTask.get()) != null) {
                handle.cancel(false);
            }
        }

        private ScheduledFuture<?> scheduleAppServerPortTask() {
            return RPMConnectionServiceImpl.this.scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

                public void run() {
                    if (RPMConnectionTask.this.isConnected()) {
                        RPMConnectionTask.this.stop();
                        return;
                    }
                    if (RPMConnectionTask.this.hasAppServerPort() && !RPMConnectionTask.this.connectTaskStarted()) {
                        RPMConnectionTask.this.stop();
                        RPMConnectionServiceImpl.this.getLogger().log(Level.FINER, "Discovered application server port");
                        RPMConnectionTask.this.connectTask.set(RPMConnectionTask.this.scheduleConnectTask());
                    }
                }
            }, RPMConnectionServiceImpl.this.getInitialAppServerPortDelay(), 5L, TimeUnit.SECONDS);
        }

        private ScheduledFuture<?> scheduleAppServerPortTimeoutTask() {
            return RPMConnectionServiceImpl.this.scheduledExecutor.schedule(new Runnable(){

                public void run() {
                    if (!RPMConnectionTask.this.connectTaskStarted()) {
                        RPMConnectionTask.this.stop();
                        if (!RPMConnectionTask.this.isConnected()) {
                            if (!RPMConnectionTask.this.hasAppServerPort()) {
                                RPMConnectionServiceImpl.this.getLogger().log(Level.FINER, "Gave up waiting for application server port");
                            }
                            RPMConnectionTask.this.connectTask.set(RPMConnectionTask.this.scheduleConnectTask());
                        }
                    }
                }
            }, RPMConnectionServiceImpl.this.getAppServerPortTimeout(), TimeUnit.SECONDS);
        }

        private ScheduledFuture<?> scheduleConnectTask() {
            return RPMConnectionServiceImpl.this.scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

                public void run() {
                    if (RPMConnectionTask.this.shouldAttemptConnection() && RPMConnectionTask.this.attemptConnection()) {
                        RPMConnectionTask.this.stop();
                    }
                }
            }, 0L, 60L, TimeUnit.SECONDS);
        }

        private boolean isMainAppConnected() {
            return ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMService().isConnected();
        }

        private boolean isConnected() {
            return this.rpmService.isConnected();
        }

        private boolean connectTaskStarted() {
            return this.connectTaskStarted.getAndSet(true);
        }

        private boolean hasAppServerPort() {
            return this.getEnvironment().getServerPort() != null;
        }

        private boolean isSyncStartup() {
            ConfigService configService = ServiceManagerFactory.getServiceManager().getConfigService();
            AgentConfig config = configService.getAgentConfig();
            return config.isSyncStartup();
        }

        private boolean shouldAttemptConnection() {
            if (this.rpmService.isMainApp() || this.isMainAppConnected()) {
                return !this.isConnected();
            }
            return false;
        }

        private boolean attemptConnection() {
            try {
                this.rpmService.launch();
                return true;
            }
            catch (Throwable e) {
                if (this.attemptCount.get() < 5) {
                    String msg = MessageFormat.format("Failed to connect to {0} for {1}: {2}", this.rpmService.getHostString(), this.rpmService.getApplicationName(), e.getMessage());
                    if (RPMConnectionServiceImpl.this.getLogger().isLoggable(Level.FINE)) {
                        RPMConnectionServiceImpl.this.getLogger().log(Level.FINE, msg, e);
                    } else {
                        RPMConnectionServiceImpl.this.getLogger().info(msg);
                    }
                } else if (this.attemptCount.get() == 5) {
                    String msg = MessageFormat.format("The agent will continue attempting to connect to {0} for {1}.  Future connection failures will not be logged.", this.rpmService.getHostString(), this.rpmService.getApplicationName());
                    RPMConnectionServiceImpl.this.getLogger().info(msg);
                }
                this.attemptCount.incrementAndGet();
                return false;
            }
        }

        private Environment getEnvironment() {
            return ServiceManagerFactory.getServiceManager().getEnvironmentService().getEnvironment();
        }
    }
}

