/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.profile.Profile;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.ProfilerService;
import com.newrelic.agent.service.ServiceManagerFactory;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProfileSession {
    private final Profile profile;
    private final ProfilerService profilerService;
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final AtomicReference<ScheduledFuture<?>> profileHandle = new AtomicReference();
    private final AtomicReference<ScheduledFuture<?>> timeoutHandle = new AtomicReference();
    private final boolean alwaysOn;

    public ProfileSession(ProfilerService profilerService, ProfilerParameters parameters, boolean alwaysOn) {
        this.profilerService = profilerService;
        this.alwaysOn = alwaysOn;
        this.profile = new Profile(parameters);
    }

    void start(long samplePeriodInMillis, long durationInMillis) {
        this.profile.start();
        if (samplePeriodInMillis == durationInMillis) {
            this.getLogger().info("Starting single sample profiling session");
            this.startSingleSample();
        } else {
            this.getLogger().log(this.alwaysOn ? Level.FINE : Level.INFO, "Starting profiling session. Duration: {0} ms, sample period: {1} ms", new Object[]{durationInMillis, samplePeriodInMillis});
            this.startMultiSample(samplePeriodInMillis, durationInMillis);
        }
    }

    private void startMultiSample(long samplePeriodInMillis, long durationInMillis) {
        ScheduledExecutorService scheduler = this.profilerService.getScheduledExecutorService();
        ScheduledFuture<?> handle = scheduler.scheduleAtFixedRate(new Runnable(){

            public void run() {
                try {
                    ProfileSession.this.profile.sampleStackTraces();
                }
                catch (Throwable t) {
                    ProfileSession.this.getLogger().log(Level.SEVERE, "An error occurred collecting a thread sample: {0}", t.toString());
                    ProfileSession.this.getLogger().log(Level.FINER, "An error occurred collecting a thread sample", t);
                }
            }
        }, 0L, samplePeriodInMillis, TimeUnit.MILLISECONDS);
        this.profileHandle.set(handle);
        handle = scheduler.schedule(new Runnable(){

            public void run() {
                ((ScheduledFuture)ProfileSession.this.profileHandle.get()).cancel(false);
                if (!ProfileSession.this.done.getAndSet(true)) {
                    ProfileSession.this.report();
                }
                ProfileSession.this.sessionCompleted();
            }
        }, durationInMillis, TimeUnit.MILLISECONDS);
        this.timeoutHandle.set(handle);
    }

    private void startSingleSample() {
        ScheduledExecutorService scheduler = this.profilerService.getScheduledExecutorService();
        ScheduledFuture<?> handle = scheduler.schedule(new Runnable(){

            public void run() {
                try {
                    ProfileSession.this.profile.sampleStackTraces();
                }
                catch (Exception e) {
                    ProfileSession.this.getLogger().log(Level.SEVERE, "An error occurred collecting a thread sample: {0}", e.toString());
                    ProfileSession.this.getLogger().log(Level.FINER, "An error occurred collecting a thread sample", e);
                }
                if (!ProfileSession.this.done.getAndSet(true)) {
                    ProfileSession.this.report();
                }
                ProfileSession.this.sessionCompleted();
            }
        }, 0L, TimeUnit.MILLISECONDS);
        this.profileHandle.set(handle);
    }

    private void report() {
        if (this.alwaysOn && this.profile.getSampleCount() == 0) {
            return;
        }
        this.profile.end();
        this.getLogger().log(Level.INFO, "Profiler finished with {0} samples", this.profile.getSampleCount());
        List<Profile> profiles = Arrays.asList(this.profile);
        try {
            ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMService().sendProfileData(profiles);
        }
        catch (IgnoreSilentlyException e) {
        }
        catch (Exception e) {
            this.getLogger().log(Level.FINE, "Unable to send profile data : {0}", e.toString());
            this.getLogger().log(Level.FINER, "Unable to send profile data", e);
        }
    }

    private void sessionCompleted() {
        this.profilerService.sessionCompleted(this);
    }

    void stop(final boolean shouldReport) {
        if (this.done.getAndSet(true)) {
            return;
        }
        this.getLogger().log(this.alwaysOn ? Level.FINE : Level.INFO, "Stopping profiling session");
        ScheduledFuture<?> handle = this.profileHandle.get();
        if (handle != null) {
            handle.cancel(false);
        }
        if ((handle = this.timeoutHandle.get()) != null) {
            handle.cancel(false);
        }
        this.profilerService.getScheduledExecutorService().schedule(new Runnable(){

            public void run() {
                if (shouldReport) {
                    ProfileSession.this.report();
                }
                ProfileSession.this.sessionCompleted();
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public boolean isDone() {
        return this.done.get();
    }

    public Long getProfileId() {
        return this.profile.getProfileId();
    }

    public Profile getProfile() {
        return this.profile;
    }

    public boolean isAlwaysOn() {
        return this.alwaysOn;
    }

    private Logger getLogger() {
        return this.profilerService.getLogger();
    }
}

