/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.normalization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IgnoreRequestException;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.normalization.NormalizationRule;
import com.newrelic.agent.normalization.RuleResult;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLNormalizer {
    public static final String URL_SEGEMENT_DELIMITER = "/";
    private static final Pattern PARAMETER_DELIMITER_PATTERN = Pattern.compile("(.*?)(\\?|#|;).*", 32);
    private List<NormalizationRule> rules = new ArrayList<NormalizationRule>();
    private final String appName;

    public URLNormalizer(AgentConfig config, String appName) {
        this.appName = appName;
    }

    public String normalizeURL(String url) throws IgnoreRequestException {
        String normalizedUrl = url;
        if (!normalizedUrl.startsWith(URL_SEGEMENT_DELIMITER)) {
            normalizedUrl = URL_SEGEMENT_DELIMITER + normalizedUrl;
        }
        for (NormalizationRule rule : this.rules) {
            RuleResult result = rule.normalizeUrl(normalizedUrl);
            if (!result.isMatch()) continue;
            if (rule.isIgnore()) {
                String msg = MessageFormat.format("Ignoring url \"{0}\" for \"{1}\" because it matched rule \"{2}\"", url, this.appName, rule);
                throw new IgnoreRequestException(msg);
            }
            String replacement = result.getReplacement();
            if (replacement != null) {
                if (Agent.LOG.isLoggable(Level.FINER)) {
                    String msg = MessageFormat.format("Normalized url \"{0}\" for \"{1}\" to \"{2}\" using rule \"{3}\"", normalizedUrl, this.appName, replacement, rule);
                    Agent.LOG.finer(msg);
                }
                normalizedUrl = replacement;
            }
            if (!rule.isTerminateChain()) continue;
            break;
        }
        return normalizedUrl;
    }

    public void setUrlRules(List<Map<String, Object>> rules) throws Exception {
        ArrayList<NormalizationRule> newRules = new ArrayList<NormalizationRule>();
        for (int i = 0; i < rules.size(); ++i) {
            Map<String, Object> rule = rules.get(i);
            NormalizationRule newRule = NormalizationRule.createRule(rule);
            newRules.add(newRule);
            if (!Agent.LOG.isLoggable(Level.FINER)) continue;
            String msg = MessageFormat.format("Setting rule for \"{0}\": \"{1}\"", this.appName, rule);
            Agent.LOG.finer(msg);
        }
        Collections.sort(newRules, new Comparator<NormalizationRule>(){

            @Override
            public int compare(NormalizationRule lhs, NormalizationRule rhs) {
                Integer lhsOrder = lhs.getOrder();
                Integer rhsOrder = rhs.getOrder();
                return lhsOrder.compareTo(rhsOrder);
            }
        });
        this.setCustomRules(newRules);
    }

    public void setCustomRules(List<NormalizationRule> newRules) {
        this.rules = newRules;
    }

    public static String getUrlBeforeParameters(String url) {
        Matcher paramDelimiterMatcher = PARAMETER_DELIMITER_PATTERN.matcher(url);
        if (paramDelimiterMatcher.matches()) {
            return paramDelimiterMatcher.group(1);
        }
        return url;
    }
}

