/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.normalization;

import com.newrelic.agent.normalization.RuleResult;
import java.text.MessageFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizationRule {
    private static final Pattern SEGMENT_SEPARATOR_PATTERN = Pattern.compile("/");
    private static final Pattern BACKREFERENCE_PATTERN = Pattern.compile("\\\\(\\d)");
    private static final String BACKREFERENCE_REPLACEMENT = "\\$$1";
    private final Pattern pattern;
    private final boolean ignore;
    private final boolean terminateChain;
    private final int order;
    private final boolean eachSegment;
    private final boolean replaceAll;
    private final String replaceRegex;
    private final ReplacementFormatter formatter;

    public NormalizationRule(String matchExp, String replacement, boolean ignore, int order, boolean terminateChain, boolean eachSegment, boolean replaceAll) throws PatternSyntaxException {
        this.ignore = ignore;
        this.order = order;
        this.terminateChain = terminateChain;
        this.eachSegment = eachSegment;
        this.replaceAll = replaceAll;
        this.pattern = Pattern.compile(matchExp, 34);
        if (replacement == null || replacement.length() == 0) {
            this.replaceRegex = null;
        } else {
            Matcher backReferenceMatcher = BACKREFERENCE_PATTERN.matcher(replacement);
            this.replaceRegex = backReferenceMatcher.replaceAll(BACKREFERENCE_REPLACEMENT);
        }
        this.formatter = ignore ? new IgnoreReplacementFormatter() : new FancyReplacementFormatter();
    }

    public boolean isTerminateChain() {
        return this.terminateChain;
    }

    public RuleResult normalizeUrl(String url) {
        return this.formatter.getRuleResult(url);
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public int getOrder() {
        return this.order;
    }

    public String toString() {
        return MessageFormat.format("match_expression: {0} replacement: {1} eval_order: {2} each_segment: {3} ignore: {4} terminate_chain: {5} replace_all {6}", this.pattern.pattern(), this.replaceRegex, this.order, this.eachSegment, this.ignore, this.terminateChain, this.replaceAll);
    }

    public static NormalizationRule createRule(Map<String, Object> rule) {
        Boolean terminateChain;
        Boolean ignore;
        Boolean replaceAll;
        Boolean eachSegment = (Boolean)rule.get("each_segment");
        if (eachSegment == null) {
            eachSegment = Boolean.FALSE;
        }
        if ((replaceAll = (Boolean)rule.get("replace_all")) == null) {
            replaceAll = Boolean.FALSE;
        }
        if ((ignore = (Boolean)rule.get("ignore")) == null) {
            ignore = Boolean.FALSE;
        }
        if ((terminateChain = (Boolean)rule.get("terminate_chain")) == null) {
            terminateChain = Boolean.TRUE;
        }
        int order = ((Number)rule.get("eval_order")).intValue();
        String matchExpression = (String)rule.get("match_expression");
        String replacement = (String)rule.get("replacement");
        return new NormalizationRule(matchExpression, replacement, ignore, order, terminateChain, eachSegment, replaceAll);
    }

    private class FancyReplacementFormatter
    implements ReplacementFormatter {
        private FancyReplacementFormatter() {
        }

        public RuleResult getRuleResult(String url) {
            if (NormalizationRule.this.eachSegment) {
                return this.forEachSegment(url);
            }
            return this.forEntireUrl(url);
        }

        private RuleResult forEachSegment(String url) {
            boolean isMatch = false;
            String[] segments = SEGMENT_SEPARATOR_PATTERN.split(url);
            for (int i = 1; i < segments.length; ++i) {
                RuleResult result;
                String segment = segments[i];
                if (segment == null || segment.length() == 0 || !(result = this.forEntireUrl(segment)).isMatch()) continue;
                isMatch = true;
                segments[i] = result.getReplacement();
            }
            if (!isMatch) {
                return RuleResult.getNoMatch();
            }
            StringBuilder path = new StringBuilder();
            for (int i = 1; i < segments.length; ++i) {
                String segment = segments[i];
                if (segment == null || segment.length() == 0) continue;
                path.append('/').append(segment);
            }
            return RuleResult.getMatch(path.toString());
        }

        private RuleResult forEntireUrl(String url) {
            Matcher matcher = NormalizationRule.this.pattern.matcher(url);
            if (matcher.find()) {
                String replacement = NormalizationRule.this.replaceRegex == null || NormalizationRule.this.replaceRegex.length() == 0 ? null : (NormalizationRule.this.replaceAll ? matcher.replaceAll(NormalizationRule.this.replaceRegex) : matcher.replaceFirst(NormalizationRule.this.replaceRegex));
                return RuleResult.getMatch(replacement);
            }
            return RuleResult.getNoMatch();
        }
    }

    private class IgnoreReplacementFormatter
    implements ReplacementFormatter {
        private IgnoreReplacementFormatter() {
        }

        public RuleResult getRuleResult(String url) {
            if (NormalizationRule.this.eachSegment) {
                return this.forEachSegment(url);
            }
            return this.forEntireUrl(url);
        }

        private RuleResult forEachSegment(String url) {
            String[] segments = SEGMENT_SEPARATOR_PATTERN.split(url);
            for (int i = 1; i < segments.length; ++i) {
                Matcher matcher;
                String segment = segments[i];
                if (segment == null || segment.length() == 0 || !(matcher = NormalizationRule.this.pattern.matcher(segment)).find()) continue;
                return RuleResult.getIgnoreMatch();
            }
            return RuleResult.getNoMatch();
        }

        private RuleResult forEntireUrl(String url) {
            Matcher matcher = NormalizationRule.this.pattern.matcher(url);
            return matcher.find() ? RuleResult.getIgnoreMatch() : RuleResult.getNoMatch();
        }
    }

    private static interface ReplacementFormatter {
        public RuleResult getRuleResult(String var1);
    }
}

