/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.jmx.JmxConfigFactory;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.stats.Stats;
import com.newrelic.agent.stats.StatsEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxService
extends AbstractService
implements HarvestListener {
    private final List<JmxConfigFactory.JmxConfig> configs = new ArrayList<JmxConfigFactory.JmxConfig>();
    private final boolean enabled;
    private final JmxConfigFactory jmxConfigFactory;
    private final boolean createMBeanServerIfNecessary;
    static final Pattern typeQueryPattern = Pattern.compile(",(.*?)=");

    public JmxService() {
        super(JmxService.class.getSimpleName());
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        Config jmxConfig = new Config((Map)config.getProperty("jmx"));
        this.enabled = jmxConfig.getProperty("enabled", true);
        this.createMBeanServerIfNecessary = jmxConfig.getProperty("create_mbean_server", true);
        InstrumentationProxy instrumentation = ServiceManagerFactory.getServiceManager().getAgent().getInstrumentation();
        this.jmxConfigFactory = JmxConfigFactory.createJmxConfigFactory(instrumentation);
    }

    public List<JmxConfigFactory.JmxConfig> getConfigurations() {
        return Collections.unmodifiableList(this.configs);
    }

    @Override
    protected void doStart() {
        if (this.enabled) {
            for (Extension extension : ServiceManagerFactory.getServiceManager().getExtensionService().getExtensions().values()) {
                Object jmx;
                if (!extension.isEnabled() || (jmx = extension.getConfiguration().getProperty("jmx")) == null || !(jmx instanceof List)) continue;
                this.addConfiguration((List)jmx);
            }
            if (this.configs.size() > 0) {
                ServiceManagerFactory.getServiceManager().getHarvestService().addHarvestListener(this);
            }
        }
    }

    public void createMBeanServerIfNecessary() {
        if (System.getProperty("com.sun.management.jmxremote") == null && MBeanServerFactory.findMBeanServer(null).isEmpty() && this.createMBeanServerIfNecessary) {
            try {
                MBeanServerFactory.createMBeanServer();
                this.getLogger().log(Level.FINE, "Created a default MBeanServer");
            }
            catch (Exception e) {
                Agent.LOG.severe("The JMX Service was unable to create a default mbean server");
            }
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    private void addConfiguration(List<Map> config) {
        if (config != null) {
            for (Map jmxConfig : config) {
                try {
                    this.addJmxConfig(this.jmxConfigFactory.getJmxConfig(jmxConfig));
                }
                catch (MalformedObjectNameException e) {}
            }
        }
    }

    void addJmxConfig(JmxConfigFactory.JmxConfig jmxConfig) {
        this.configs.add(jmxConfig);
    }

    @Override
    protected void doStop() {
        this.configs.clear();
    }

    @Override
    public void beforeHarvest(IRPMService rpmService) {
        if (!rpmService.isMainApp()) {
            return;
        }
        Agent.LOG.log(Level.FINER, "Harvesting JMX metrics");
        this.process(rpmService);
    }

    @Override
    public void afterHarvest(IRPMService rpmService) {
    }

    private void process(IRPMService rpmService, List<MBeanServer> srvrList, JmxConfigFactory.JmxConfig config, Set<String> metricNames) {
        ObjectName name = config.getObjectName();
        if (name == null) {
            return;
        }
        StatsEngine statsEngine = rpmService.getStatsEngine();
        for (MBeanServer server : srvrList) {
            Set<ObjectInstance> queryMBeans = server.queryMBeans(name, null);
            this.getLogger().log(Level.FINER, "JMX Service : MBeans query {0}, matches {1}", new Object[]{name, queryMBeans.size()});
            block5: for (ObjectInstance instance : queryMBeans) {
                ObjectName actualName = instance.getObjectName();
                String rootMetricName = JmxService.getRootMetricName(config, actualName);
                try {
                    Map<String, JmxConfigFactory.JmxMetric> metrics = config.getMetrics();
                    String[] attributes = metrics.keySet().toArray(new String[metrics.size()]);
                    AttributeList attributeList = server.getAttributes(instance.getObjectName(), attributes);
                    for (Object attributeObj : attributeList) {
                        Attribute attribute = (Attribute)attributeObj;
                        JmxConfigFactory.JmxMetric metric = metrics.get(attribute.getName());
                        if (metric == null) {
                            Agent.LOG.log(Level.SEVERE, "An error occurred fetching the JMX metric \"{0}\"", rootMetricName + attribute.getName());
                            continue block5;
                        }
                        String metricName = rootMetricName + metric.getAttribute();
                        if (metricNames.contains(metricName)) {
                            this.getLogger().log(Level.FINE, "The agent was configured to record the JMX metric \"{0}\" more than once", metricName);
                            continue;
                        }
                        metricNames.add(metricName);
                        Object value = attribute.getValue();
                        Number num = null;
                        if (value instanceof Number) {
                            num = (Number)value;
                        } else if (value != null) {
                            try {
                                num = Float.valueOf(Float.parseFloat(value.toString()));
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        if (num != null) {
                            this.getLogger().log(Level.FINER, "Recording JMX metric {0} : {1}", new Object[]{metricName, value});
                            Stats stats = metric.getStats(statsEngine, metricName);
                            stats.recordDataPoint(num.floatValue());
                            continue;
                        }
                        if (value == null) {
                            this.getLogger().log(Level.FINE, "MBean {0} attribute {1} value is null", new Object[]{instance.getObjectName(), metric.getAttribute()});
                            continue;
                        }
                        this.getLogger().log(Level.FINE, "MBean {0} attribute {1} is not a number ({2}/{3})", new Object[]{instance.getObjectName(), metric.getAttribute(), value, value.getClass().getName()});
                    }
                }
                catch (Exception e) {
                    this.getLogger().log(Level.FINE, "An error occurred fetching JMX metric for {0}", name);
                    this.getLogger().log(Level.FINER, "JMX error", e);
                }
            }
        }
    }

    static String getRootMetricName(JmxConfigFactory.JmxConfig config, ObjectName actualName) {
        Hashtable<String, String> keyProperties = actualName.getKeyPropertyList();
        String type = keyProperties.remove("type");
        StringBuilder rootPath = new StringBuilder("JMX").append('/').append(actualName.getDomain()).append('/').append(type);
        if (keyProperties.size() > 1) {
            String str = config.getObjectNameString();
            Matcher matcher = typeQueryPattern.matcher(str);
            while (matcher.find()) {
                String group = matcher.group(1);
                String val = keyProperties.remove(group);
                if (val == null) continue;
                rootPath.append('/');
                rootPath.append(JmxService.formatSegment(val));
            }
        }
        if (keyProperties.size() == 1) {
            rootPath.append('/');
            rootPath.append(JmxService.formatSegment(keyProperties.entrySet().iterator().next().getValue()));
        }
        rootPath.append('/');
        return rootPath.toString();
    }

    private void process(IRPMService rpmService) {
        HashSet<String> metricNames = new HashSet<String>();
        ArrayList<MBeanServer> srvrList = MBeanServerFactory.findMBeanServer(null);
        this.getLogger().log(Level.FINE, "JMX Service : querying MBeans ({0})", srvrList.size());
        for (JmxConfigFactory.JmxConfig config : this.configs) {
            this.process(rpmService, srvrList, config, metricNames);
        }
    }

    private static String formatSegment(String metricSegment) {
        if (metricSegment.startsWith("/")) {
            return metricSegment.substring(1);
        }
        return metricSegment;
    }
}

