/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.solr;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.solr.AbstractSolrPointCut;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.io.InputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;

@PointCut
public class SolrCorePointCut
extends AbstractSolrPointCut {
    public SolrCorePointCut(ClassTransformer classTransformer) {
        super((Class<? extends AbstractSolrPointCut>)SolrCorePointCut.class, (ClassMatcher)new ExactClassMatcher("org/apache/solr/core/SolrCore"), SolrCorePointCut.createExactMethodMatcher("initIndex", "()V"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object core, Object[] args) {
        String version = null;
        try {
            InputStream iStream = core.getClass().getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(iStream);
            version = manifest.getMainAttributes().getValue("Specification-Version");
        }
        catch (Exception e) {
            Agent.LOG.fine("Unable to determine the Solr version : " + e.toString());
        }
        try {
            version = version == null ? this.getVersion(core) : version;
        }
        catch (Exception e) {
            version = "1.0";
        }
        Agent.LOG.fine("Setting environment variable: Solr Version: " + version);
        ServiceManagerFactory.getServiceManager().getEnvironmentService().getEnvironment().addVariable("Solr Version", version);
        this.checkJmxConfig(core);
        return null;
    }

    private void checkJmxConfig(Object core) {
        try {
            Object config = core.getClass().getClassLoader().loadClass("org.apache.solr.core.SolrCore").getMethod("getSolrConfig", new Class[0]).invoke(core, new Object[0]);
            Object jmxConfig = config.getClass().getDeclaredField("jmxConfig").get(config);
            boolean enabled = jmxConfig.getClass().getDeclaredField("enabled").getBoolean(jmxConfig);
            if (!enabled) {
                Agent.LOG.severe("Solr JMX metrics are not enabled.  The agent will not report Solr JMX data.  Add a <jmx/> node to solrconfig.xml to enable them (refer to the Solr documentation).");
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.SEVERE, "Unable to determine if Solr JMX metrics are enabled : {0}", e.toString());
        }
    }

    private Object getVersion(Object core) throws Exception {
        return core.getClass().getMethod("getVersion", new Class[0]).invoke(core, new Object[0]);
    }
}

