/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InstanceMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ErrorReportingTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.util.ServletUtils;
import com.newrelic.agent.util.TransactionUtils;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

@PointCut
public class ServletFilterPointCut
extends TracerFactoryPointCut {
    private static final String SERVLET_FILTER_INTERFACE = "javax/servlet/Filter";
    private static final String INIT_METHOD_NAME = "init";
    private static final String INIT_METHOD_DESC = "(Ljavax/servlet/FilterConfig;)V";
    private static final String DESTROY_METHOD_NAME = "destroy";
    private static final String DESTROY_METHOD_DESC = "()V";
    private static final String DO_FILTER_METHOD_NAME = "doFilter";
    private static final String DO_FILTER_METHOD_DESC = "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;Ljavax/servlet/FilterChain;)V";
    private static final int SERVLET_VERSION_3 = 3;
    private final Map<Object, Object> filterToservletContexts = new ConcurrentHashMap<Object, Object>();

    public ServletFilterPointCut(ClassTransformer classTransformer) {
        super(ServletFilterPointCut.class, (ClassMatcher)new InterfaceMatcher(SERVLET_FILTER_INTERFACE), (MethodMatcher)new InstanceMethodMatcher(OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher(INIT_METHOD_NAME, INIT_METHOD_DESC), new ExactMethodMatcher(DESTROY_METHOD_NAME, DESTROY_METHOD_DESC), new ExactMethodMatcher(DO_FILTER_METHOD_NAME, DO_FILTER_METHOD_DESC))));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object filter, Object[] args) {
        try {
            if (DO_FILTER_METHOD_NAME == sig.getMethodName()) {
                return this.createTracer(transaction, sig, filter, args);
            }
            if (INIT_METHOD_NAME == sig.getMethodName()) {
                this.handleInit(transaction, filter, args[0]);
            } else if (DESTROY_METHOD_NAME == sig.getMethodName()) {
                this.handleDestroy(transaction, filter);
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception in {0} handling {1}: {2}", ServletFilterPointCut.class.getSimpleName(), sig, e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            }
            Agent.LOG.finer(MessageFormat.format(msg, e));
        }
        return null;
    }

    private Tracer createTracer(final Transaction transaction, final ClassMethodSignature sig, final Object filter, final Object[] args) {
        ClassMethodMetricNameFormat format = new ClassMethodMetricNameFormat(sig, filter, "ServletFilter");
        return new ErrorReportingTracer(transaction, sig, filter, format){

            protected void doFinish(int opcode, Object returnValue) {
                super.doFinish(opcode, returnValue);
                try {
                    ServletFilterPointCut.this.handleDoFilter(transaction, filter, args[0]);
                }
                catch (Exception e) {
                    String msg = MessageFormat.format("Exception in {0} handling {1}: {2}", ServletFilterPointCut.class.getSimpleName(), sig, e);
                    if (Agent.LOG.isLoggable(Level.FINEST)) {
                        Agent.LOG.log(Level.FINEST, msg, e);
                    }
                    Agent.LOG.finer(MessageFormat.format(msg, e));
                }
            }
        };
    }

    private void handleInit(Transaction transaction, Object filter, Object filterConfig) throws Exception {
        Object servletContext = ServletUtils.getServletContextFromFilterConfig(filterConfig);
        if (transaction.isAutoAppNamingEnabled() && !this.isVersion3(servletContext)) {
            this.filterToservletContexts.put(filter, servletContext);
        }
        TransactionUtils.setServerInfo(transaction, servletContext);
    }

    private void handleDestroy(Transaction transaction, Object filter) {
        if (transaction.isAutoAppNamingEnabled()) {
            this.filterToservletContexts.remove(filter);
        }
    }

    private void handleDoFilter(Transaction transaction, Object filter, Object servletRequest) throws Exception {
        if (transaction.isAutoAppNamingEnabled() && transaction.getApplicationName() == null) {
            Object servletContext = this.getServletContext(filter, servletRequest);
            TransactionUtils.setAppNameFromServletContext(transaction, servletContext);
        }
    }

    private boolean isVersion3(Object servletContext) throws Exception {
        int majorVersion = ServletUtils.getMajorVersion(servletContext);
        return majorVersion >= 3;
    }

    private Object getServletContextFromServletRequest(Object servletRequest) throws Exception {
        try {
            return ServletUtils.getServletContextFromServletRequest(servletRequest);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Object getServletContext(Object filter, Object servletRequest) throws Exception {
        Object servletContext = this.getServletContextFromServletRequest(servletRequest);
        if (servletContext == null) {
            servletContext = this.filterToservletContexts.get(filter);
        }
        return servletContext;
    }
}

