/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.servlet;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InstanceMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.OtherDispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;

@PointCut
public class ServletContextListenerPointCut
extends TracerFactoryPointCut {
    public ServletContextListenerPointCut(ClassTransformer classTransformer) {
        super(ServletContextListenerPointCut.class, (ClassMatcher)new InterfaceMatcher("javax/servlet/ServletContextListener"), (MethodMatcher)new InstanceMethodMatcher(OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher("contextInitialized", "(Ljavax/servlet/ServletContextEvent;)V"), new ExactMethodMatcher("contextDestroyed", "(Ljavax/servlet/ServletContextEvent;)V"))));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object listener, Object[] args) {
        return new OtherDispatcherTracer(transaction, sig, listener, new ClassMethodMetricNameFormat(sig, listener, "OtherTransaction/Initializer/ServletContextListener")){

            protected void doFinish(int opcode, Object returnValue) {
                super.doFinish(opcode, returnValue);
                if (this.getChildren().isEmpty()) {
                    this.getTransaction().setTraceDisabled(true);
                }
            }
        };
    }
}

