/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.net;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ExternalComponentPointCut;
import com.newrelic.agent.tracers.ExternalComponentTracer;
import com.newrelic.agent.tracers.IOTracer;
import com.newrelic.agent.tracers.Tracer;
import java.lang.reflect.Field;
import java.net.Socket;
import java.util.Map;
import java.util.logging.Level;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class SocketInputStreamPointCut
extends ExternalComponentPointCut {
    public static final String[] INPUT_STREAM_METHODS = new String[]{"()I", "([BII)I"};
    public static final String SOCKET_INPUT_STREAM_CLASS_NAME = "java/net/SocketInputStream";
    private static final String OBJECT_MAP_KEY = "streamToMetric";

    public SocketInputStreamPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration("socket_input_stream", null, false), (ClassMatcher)new ExactClassMatcher(SOCKET_INPUT_STREAM_CLASS_NAME), SocketInputStreamPointCut.createExactMethodMatcher("read", INPUT_STREAM_METHODS));
        classTransformer.getClassNameFilter().addIncludeRegex("(^java/net/SocketInputStream)");
    }

    protected Tracer getTracerImpl(Transaction transaction, ClassMethodSignature sig, Object inputStream, Object[] args) {
        Map<Object, ExternalComponentTracer.MetricNameFormatWithHost> streamToMetric = transaction.getObjectMap(OBJECT_MAP_KEY);
        ExternalComponentTracer.MetricNameFormatWithHost metricFormat = (ExternalComponentTracer.MetricNameFormatWithHost)streamToMetric.get(inputStream);
        if (metricFormat == null) {
            try {
                Field socketField = inputStream.getClass().getDeclaredField("socket");
                socketField.setAccessible(true);
                Socket socket = (Socket)socketField.get(inputStream);
                String host = socket.getInetAddress().getHostName();
                metricFormat = ExternalComponentTracer.getMetricNameFormat(host, "SocketInputStream");
                streamToMetric.put(inputStream, metricFormat);
            }
            catch (Throwable t) {
                metricFormat = ExternalComponentTracer.getMetricNameFormat("errorFetchingHost", "SocketInputStream");
                streamToMetric.put(inputStream, metricFormat);
                Agent.LOG.log(Level.FINER, "Error getting url from http input stream", t);
            }
        }
        return new SocketInputStreamTracer(this, transaction, sig, inputStream, metricFormat);
    }

    public void noticeTransformerStarted(ClassTransformer classTransformer) {
        InstrumentationProxy instrumentation = ServiceManagerFactory.getServiceManager().getAgent().getInstrumentation();
        try {
            instrumentation.retransformUninstrumentedClasses("java.net.SocketInputStream");
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINER, "Unable to retransform SocketInputStream", e);
        }
    }

    private static final class SocketInputStreamTracer
    extends ExternalComponentTracer
    implements IOTracer {
        private SocketInputStreamTracer(PointCut pc, Transaction transaction, ClassMethodSignature sig, Object object, ExternalComponentTracer.MetricNameFormatWithHost metricNameFormat) {
            super(transaction, sig, object, metricNameFormat);
        }

        public TransactionSegment getTransactionSegment(SqlObfuscator sqlObfuscator, long startTime, TransactionSegment lastSibling) {
            if (lastSibling != null && lastSibling.getMetricName().equals(this.getTransactionSegmentName())) {
                lastSibling.merge(this);
                return lastSibling;
            }
            return super.getTransactionSegment(sqlObfuscator, startTime, lastSibling);
        }
    }
}

