/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.hibernate;

import com.newrelic.agent.Agent;
import com.newrelic.agent.MetricSpec;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InstanceMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.util.Strings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@PointCut
public class HibernateSessionPointCut
extends TracerFactoryPointCut {
    private static final String LIST_METHOD_NAME = "list";
    private static final String SAVE_OR_UPDATE_METHOD_NAME = "saveOrUpdate";
    private static final String UPDATE_METHOD_NAME = "update";
    private static final String SAVE_METHOD_NAME = "save";
    private static final String PERSIST_METHOD_NAME = "persist";
    private static final String DELETE_METHOD_NAME = "delete";
    private static final String LOAD_METHOD_NAME = "load";
    private static final String GET_METHOD_NAME = "get";
    private static final String REFRESH_METHOD_NAME = "refresh";
    private final Map<String, TracerFactory> tracerFactories = new HashMap<String, TracerFactory>(){
        {
            this.put(HibernateSessionPointCut.GET_METHOD_NAME, new BasicTracerFactory(HibernateSessionPointCut.GET_METHOD_NAME));
            this.put(HibernateSessionPointCut.LOAD_METHOD_NAME, new BasicTracerFactory(HibernateSessionPointCut.LOAD_METHOD_NAME));
            this.put(HibernateSessionPointCut.PERSIST_METHOD_NAME, new BasicTracerFactory(HibernateSessionPointCut.PERSIST_METHOD_NAME));
            this.put(HibernateSessionPointCut.DELETE_METHOD_NAME, new BasicTracerFactory(HibernateSessionPointCut.DELETE_METHOD_NAME));
            this.put(HibernateSessionPointCut.SAVE_METHOD_NAME, new BasicTracerFactory(HibernateSessionPointCut.SAVE_METHOD_NAME));
            this.put(HibernateSessionPointCut.UPDATE_METHOD_NAME, new BasicTracerFactory(HibernateSessionPointCut.UPDATE_METHOD_NAME));
            this.put(HibernateSessionPointCut.REFRESH_METHOD_NAME, new BasicTracerFactory(HibernateSessionPointCut.REFRESH_METHOD_NAME));
            this.put(HibernateSessionPointCut.SAVE_OR_UPDATE_METHOD_NAME, new BasicTracerFactory(HibernateSessionPointCut.SAVE_OR_UPDATE_METHOD_NAME));
            this.put(HibernateSessionPointCut.LIST_METHOD_NAME, new ListTracerFactory());
        }
    };

    public HibernateSessionPointCut(ClassTransformer classTransformer) {
        super(HibernateSessionPointCut.class, (ClassMatcher)new ExactClassMatcher("org/hibernate/impl/SessionImpl"), (MethodMatcher)new InstanceMethodMatcher(OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher(GET_METHOD_NAME, "(Ljava/lang/String;Ljava/io/Serializable;)Ljava/lang/Object;"), new ExactMethodMatcher(LOAD_METHOD_NAME, "(Ljava/lang/Object;Ljava/io/Serializable;)V", "(Ljava/lang/String;Ljava/io/Serializable;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/io/Serializable;Lorg/hibernate/LockMode;)Ljava/lang/Object;"), new ExactMethodMatcher(DELETE_METHOD_NAME, "(Ljava/lang/Object;)V", "(Ljava/lang/String;Ljava/lang/Object;)V"), new ExactMethodMatcher(PERSIST_METHOD_NAME, "(Ljava/lang/String;Ljava/lang/Object;)V"), new ExactMethodMatcher(SAVE_METHOD_NAME, "(Ljava/lang/String;Ljava/lang/Object;)Ljava/io/Serializable;", "(Ljava/lang/String;Ljava/lang/Object;Ljava/io/Serializable;)V"), new ExactMethodMatcher(UPDATE_METHOD_NAME, "(Ljava/lang/String;Ljava/lang/Object;)V", "(Ljava/lang/String;Ljava/lang/Object;Ljava/io/Serializable;)V"), new ExactMethodMatcher(SAVE_OR_UPDATE_METHOD_NAME, "(Ljava/lang/String;Ljava/lang/Object;)V", "(Ljava/lang/Object;)V"), new ExactMethodMatcher(REFRESH_METHOD_NAME, "(Ljava/lang/Object;)V", "(Ljava/lang/Object;Ljava/util/Map;)V", "(Ljava/lang/Object;Lorg/hibernate/LockMode;)V"), new ExactMethodMatcher(LIST_METHOD_NAME, "(Lorg/hibernate/impl/CriteriaImpl;)Ljava/util/List;"))));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        TracerFactory factory = this.tracerFactories.get(sig.getMethodName());
        if (factory == null) {
            return null;
        }
        return factory.getTracer(transaction, sig, object, args);
    }

    static String getModelName(ClassMethodSignature sig, Object[] args) {
        Object model;
        Object object = model = args[0] == null ? args[1] : args[0];
        if (model == null) {
            if (Agent.isDebugEnabled()) {
                Agent.LOG.finer("Unable to get Hibernate model name for call to " + sig + Arrays.asList(args));
            }
            return "Unknown";
        }
        if (model instanceof String) {
            return (String)model;
        }
        if (model instanceof Class) {
            return ((Class)model).getName();
        }
        return model.getClass().getName();
    }

    private class ListTracerFactory
    implements TracerFactory {
        private ListTracerFactory() {
        }

        public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
            try {
                String entityName = (String)args[0].getClass().getMethod("getEntityOrClassName", new Class[0]).invoke(args[0], new Object[0]);
                return new HibernateTracer(transaction, sig, object, entityName, HibernateSessionPointCut.LIST_METHOD_NAME);
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINER, "Unable to parse the Hibernate entity name", e);
                return null;
            }
        }
    }

    private class BasicTracerFactory
    implements TracerFactory {
        private final String operation;

        public BasicTracerFactory(String operation) {
            this.operation = operation;
        }

        public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
            String modelName = HibernateSessionPointCut.getModelName(sig, args);
            return new HibernateTracer(transaction, sig, object, modelName, this.operation);
        }
    }

    private static class HibernateTracer
    extends DefaultTracer {
        private final String operation;

        public HibernateTracer(Transaction transaction, ClassMethodSignature sig, Object object, String model, String operation) {
            super(transaction, sig, object, new SimpleMetricNameFormat(Strings.join('/', "ORM/Hibernate", model, operation)));
            this.operation = operation;
        }

        protected void doRecordMetrics(StatsEngine statsEngine, TransactionData transactionData) {
            super.doRecordMetrics(statsEngine, transactionData);
            statsEngine.getResponseTimeStats(this.getMetricName()).recordResponseTime(this.getDuration(), TimeUnit.NANOSECONDS);
            statsEngine.getResponseTimeStats("ORM/Hibernate/" + this.operation).recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
            statsEngine.getResponseTimeStats("ORM/all").recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
            statsEngine.getResponseTimeStats(transactionData.isWebTransaction() ? MetricSpec.WEB_TRANSACTION_ORM_ALL : MetricSpec.OTHER_TRANSACTION_ORM_ALL).recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
        }
    }
}

