/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks.spring;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;

@PointCut
public class SpringWildcardPathPointCut
extends TracerFactoryPointCut {
    public SpringWildcardPathPointCut(ClassTransformer classTransformer) {
        super(SpringWildcardPathPointCut.class, (ClassMatcher)new ExactClassMatcher("org/springframework/web/util/UrlPathHelper"), SpringWildcardPathPointCut.createExactMethodMatcher("getLookupPathForRequest", "(Ljavax/servlet/http/HttpServletRequest;)Ljava/lang/String;"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object urlHelper, Object[] args) {
        return new SpringWildcardTracer(transaction, sig, urlHelper);
    }

    public boolean isEnabled() {
        return ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().getProperty("enable_spring_tracing", true);
    }

    private static class SpringWildcardTracer
    extends DefaultTracer {
        public SpringWildcardTracer(Transaction transaction, ClassMethodSignature sig, Object urlHelper) {
            super(transaction, sig, urlHelper);
            this.setRecordMetric(false);
        }

        protected void doFinish(int opcode, Object path) {
            super.doFinish(opcode, path);
        }
    }
}

