/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.MethodExitTracer;
import com.newrelic.agent.tracers.Tracer;

@PointCut
public class PathMapperPointCut
extends TracerFactoryPointCut {
    private static final String SITEMESH_WEB_TRANSACTION = "WebTransaction/SiteMesh";

    public PathMapperPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration(PathMapperPointCut.class.getName(), null, false), (ClassMatcher)new ExactClassMatcher("com/opensymphony/module/sitemesh/mapper/PathMapper"), (MethodMatcher)new ExactMethodMatcher("findKey", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        return new PathMapperTracer(transaction, sig, object, (String)args[0]);
    }

    private static class PathMapperTracer
    extends MethodExitTracer {
        private Transaction transaction;

        public PathMapperTracer(Transaction transaction, ClassMethodSignature sig, Object mapper, String path) {
            super(sig);
            this.transaction = transaction;
        }

        protected void doFinish(int opcode, Object key) {
            if (key != null) {
                Agent.LOG.finer("Normalizing path using SiteMesh config");
                String path = key.toString();
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                this.transaction.setNormalizedUri(PathMapperPointCut.SITEMESH_WEB_TRANSACTION + path);
            }
            this.transaction = null;
        }
    }
}

