/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.MetricSpec;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.ParsedDatabaseStatement;
import com.newrelic.agent.instrumentation.pointcuts.database.ConnectionFactory;
import com.newrelic.agent.instrumentation.pointcuts.database.DefaultExplainPlanExecutor;
import com.newrelic.agent.instrumentation.pointcuts.database.ExplainPlanExecutor;
import com.newrelic.agent.instrumentation.pointcuts.database.SqlDriverPointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.StatementData;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DatabaseTracer;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SqlStatementTracer
extends DefaultTracer
implements DatabaseTracer {
    public static final String EXPLAIN_PLAN_PARAMETER_NAME = "explanation";
    public static final String SQL_PARAMETER_NAME = "sql";
    public static final String SQL_OBFUSCATED_PARAMETER_NAME = "sql_obfuscated";
    public static final String BACKTRACE_PARAMETER_NAME = "backtrace";
    private static final MetricNameFormat sUnknownSQLNameFormat = new SimpleMetricNameFormat("Database/UnknownSql");
    private ParsedDatabaseStatement parsedStatement;
    private StatementData statementData;
    private ExplainPlanExecutor explainPlanExecutor;
    private ConnectionFactory connectionFactory;

    public SqlStatementTracer(Transaction transaction, ClassMethodSignature sig, Object statementObject, StatementData statementData) {
        super(transaction, sig, statementObject);
        this.statementData = statementData;
        if (Agent.isDebugEnabled() && statementData == null) {
            Agent.LOG.finer("No sql for sql statement " + statementObject);
        }
    }

    protected void doFinish(Throwable throwable) {
        String sql;
        String string = sql = this.statementData == null ? null : this.statementData.getSql();
        if (sql != null) {
            this.getTransaction().getParameters().put(SQL_PARAMETER_NAME, sql);
        }
        super.doFinish(throwable);
    }

    protected void reset() {
        super.reset();
        this.statementData = null;
    }

    protected void doFinish(int opcode, Object returnValue) {
        super.doFinish(opcode, returnValue);
        if (this.statementData != null) {
            String sql;
            if (this.generateTransactionSegment && this.captureSql() && (sql = this.statementData.getSql()) != null) {
                this.put(SQL_PARAMETER_NAME, sql);
            }
            this.parsedStatement = this.statementData.getParsedStatement(returnValue);
            if (this.parsedStatement == null && this.statementData.getSqlForExplainPlan() != null && Agent.LOG.isLoggable(Level.FINE)) {
                String msg = MessageFormat.format("UNKNOWNSQL for {0}: {1}", this.getClassMethodSignature(), this.statementData.getSqlForExplainPlan());
                Agent.LOG.log(Level.FINE, msg);
            }
        }
        this.setRecordMetric(this.parsedStatement != null && this.parsedStatement.recordMetric());
        if (this.parsedStatement == null) {
            this.setMetricNameFormat(sUnknownSQLNameFormat);
        } else {
            this.setMetricNameFormat(this.parsedStatement);
        }
        if (this.generateTransactionSegment && this.statementData != null && this.statementData.getSql() != null) {
            TransactionTracerConfig transactionTracerConfig = this.getTransaction().getTransactionTracerConfig();
            double stackTraceThreshold = transactionTracerConfig.getStackTraceThresholdInMillis();
            double explainThreshold = transactionTracerConfig.getExplainThresholdInMillis();
            int stackTraceMax = transactionTracerConfig.getMaxStackTraces();
            if ((double)this.getDurationInMilliseconds() > stackTraceThreshold && this.getTransaction().getStackTraceCount() <= stackTraceMax) {
                this.storeStackTrace();
                this.getTransaction().incrementStackTraceCount();
            }
            if (this.parsedStatement != null) {
                if (transactionTracerConfig.isExplainEnabled()) {
                    this.captureExplain(this.parsedStatement, explainThreshold, transactionTracerConfig);
                } else if (Agent.isDebugEnabled()) {
                    Agent.LOG.log(Level.FINER, "Statement explain enabled: {0}, exceeded threshold?: {1}", new Object[]{this.statementData.isExplainSupported(), (double)this.getDurationInMilliseconds() > explainThreshold});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void captureExplain(ParsedDatabaseStatement parsedStatement, double explainThreshold, TransactionTracerConfig transactionTracerConfig) {
        block11: {
            if (!((double)this.getDurationInMilliseconds() > explainThreshold)) return;
            if (!"select".equals(parsedStatement.getOperation())) return;
            if (!this.statementData.isExplainSupported()) {
                this.setExplainPlan("Unable to run the explain plan for this statement (unsupported type)");
                return;
            }
            if (this.getTransaction().getExplainPlanCount() >= transactionTracerConfig.getMaxExplainPlans()) {
                if (this.getTransaction().getExplainPlanCount() != transactionTracerConfig.getMaxExplainPlans()) return;
                Agent.LOG.log(Level.FINER, "Reached the maximum number of explain plans.");
                return;
            }
            String sql = this.statementData.getSqlForExplainPlan();
            if (sql == null) {
                this.setExplainPlan("Unable to run the explain plan because we have no sql");
                return;
            }
            try {
                try {
                    Connection connection = this.statementData.getStatement().getConnection();
                    if (connection == null) {
                        this.setExplainPlan("Unable to run the explain plan because the statement returned a null connection");
                        Agent.LOG.log(Level.FINER, "Unable to run an explain plan because the Statement.getConnection() returned null : " + this.statementData.getStatement().getClass().getName());
                        Object var8_7 = null;
                        if (this.explainPlanExecutor != null) return;
                        this.connectionFactory = null;
                        return;
                    }
                    this.connectionFactory = SqlDriverPointCut.getConnectionFactory(this.getTransaction(), connection);
                    if (this.connectionFactory != null) {
                        this.explainPlanExecutor = new DefaultExplainPlanExecutor(sql){

                            protected void setExplainPlan(Object[] explainPlan) {
                                SqlStatementTracer.this.setExplainPlan(explainPlan);
                            }
                        };
                        this.getTransaction().incrementExplainPlanCount();
                        break block11;
                    }
                    this.setExplainPlan("Unable to create a connection to run the explain plan");
                    if (Agent.isDebugEnabled()) {
                        Agent.LOG.log(Level.FINER, "Unable to run explain plan because no connection factory ({0}) was found for connection {1}, statement {2}", new Object[]{SqlDriverPointCut.getAgentConnectionTracker(this.getTransaction()).size(), connection.getClass().getName(), this.statementData.getStatement().getClass().getName()});
                    }
                }
                catch (SQLException e) {
                    this.setExplainPlan("An error occurred running the explain plan - " + e.getMessage());
                    Agent.LOG.log(Level.FINER, "An error occurred creating an explain plan executor", e);
                    Object var8_9 = null;
                    if (this.explainPlanExecutor != null) return;
                    this.connectionFactory = null;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (this.explainPlanExecutor != null) throw throwable;
                this.connectionFactory = null;
                throw throwable;
            }
        }
        Object var8_8 = null;
        if (this.explainPlanExecutor != null) return;
        this.connectionFactory = null;
    }

    private boolean captureSql() {
        return "off" != this.getTransaction().getAgentConfig().getTransactionTracerConfig().getRecordSql();
    }

    void storeStackTrace() {
        this.put(BACKTRACE_PARAMETER_NAME, Thread.currentThread().getStackTrace());
    }

    final StatementData getStatementData() {
        return this.statementData;
    }

    final void setStatementData(StatementData statementData) {
        this.statementData = statementData;
    }

    public void setExplainPlan(Object ... explainPlan) {
        this.put(EXPLAIN_PLAN_PARAMETER_NAME, Arrays.asList(explainPlan));
    }

    protected void doRecordMetrics(StatsEngine statsEngine, TransactionData transactionData) {
        if (this.getMetricName() != null) {
            statsEngine.getResponseTimeStats(this.getMetricName()).recordResponseTime(this.getDuration(), TimeUnit.NANOSECONDS);
            if (this.parsedStatement != null) {
                statsEngine.getResponseTimeStats("Database/" + this.parsedStatement.getOperation()).recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
                statsEngine.getResponseTimeStats(MetricSpec.DATABASE_ALL).recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
                statsEngine.getResponseTimeStats(transactionData.isWebTransaction() ? MetricSpec.WEB_TRANSACTION_DATABASE_ALL : MetricSpec.OTHER_TRANSACTION_DATABASE_ALL).recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
            }
        }
    }

    public ExplainPlanExecutor getExplainPlanExecutor() {
        return this.explainPlanExecutor;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

