/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.JDBCClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InstanceMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.AbstractPreparedStatementPointCut;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.MethodExitTracerNoSkip;
import com.newrelic.agent.tracers.Tracer;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

@PointCut
public class ParameterizedPreparedStatementPointCut
extends AbstractPreparedStatementPointCut {
    private static final String NAME = "jdbc_parameterized_prepared_statement";
    private static final String SET_INT_METHOD_NAME = "setInt";
    private static final String SET_NULL_METHOD_NAME = "setNull";
    private static final String SET_BOOLEAN_METHOD_NAME = "setBoolean";
    private static final String SET_BYTE_METHOD_NAME = "setByte";
    private static final String SET_SHORT_METHOD_NAME = "setShort";
    private static final String SET_LONG_METHOD_NAME = "setLong";
    private static final String SET_FLOAT_METHOD_NAME = "setFloat";
    private static final String SET_DOUBLE_METHOD_NAME = "setDouble";
    private static final String SET_BIG_DECIMAL_METHOD_NAME = "setBigDecimal";
    private static final String SET_STRING_METHOD_NAME = "setString";
    private static final String SET_DATE_METHOD_NAME = "setDate";
    private static final String SET_TIME_METHOD_NAME = "setTime";
    private static final String SET_TIMESTAMP_METHOD_NAME = "setTimestamp";
    private static final String CLEAR_PARAMETERS_METHOD_NAME = "clearParameters";
    private static final MethodMatcher METHOD_MATCHER = new InstanceMethodMatcher(OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher("setInt", "(II)V"), new ExactMethodMatcher("setBoolean", "(IZ)V"), new ExactMethodMatcher("setByte", "(IB)V"), new ExactMethodMatcher("setShort", "(IS)V"), new ExactMethodMatcher("setLong", "(IJ)V"), new ExactMethodMatcher("setFloat", "(IF)V"), new ExactMethodMatcher("setDouble", "(ID)V"), new ExactMethodMatcher("setBigDecimal", "(ILjava/math/BigDecimal;)V"), new ExactMethodMatcher("setString", "(ILjava/lang/String;)V"), new ExactMethodMatcher("setDate", "(ILjava/sql/Date;)V"), new ExactMethodMatcher("setTime", "(ILjava/sql/Time;)V"), new ExactMethodMatcher("setTimestamp", "(ILjava/sql/Timestamp;)V"), new ExactMethodMatcher("clearParameters", "()V"), new ExactMethodMatcher("setNull", "(II)V")));

    public ParameterizedPreparedStatementPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration(NAME, null, ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().isGenericJDBCSupportEnabled()), ParameterizedPreparedStatementPointCut.createClassMatcher(), METHOD_MATCHER);
    }

    private static final ClassMatcher createClassMatcher() {
        LinkedList<ClassMatcher> classMatchers = new LinkedList<ClassMatcher>();
        List<String> jdbcClasses = JDBCClassTransformer.getJdbcStatementClasses();
        for (String jdbcClass : jdbcClasses) {
            classMatchers.add(new ExactClassMatcher(jdbcClass));
        }
        return new OrClassMatcher(classMatchers);
    }

    protected String findSql(Transaction transaction, ClassMethodSignature sig, Object statement) throws Exception {
        return null;
    }

    public Tracer getTracer(Transaction transaction, final ClassMethodSignature sig, final Object statement, final Object[] args) {
        if ("raw" == transaction.getTransactionTracerConfig().getRecordSql()) {
            return new MethodExitTracerNoSkip(sig, transaction){

                protected void doFinish(int opcode, Object returnValue) {
                    try {
                        if (ParameterizedPreparedStatementPointCut.CLEAR_PARAMETERS_METHOD_NAME == sig.getMethodName()) {
                            Map<Integer, Object> params = ParameterizedPreparedStatementPointCut.this.getParameterMap(statement);
                            if (params != null) {
                                params.clear();
                            }
                        } else {
                            Map<Integer, Object> params = ParameterizedPreparedStatementPointCut.this.getOrCreateParameterMap(statement);
                            Integer index = (Integer)args[0];
                            Object value = args[1];
                            params.put(index, value);
                        }
                    }
                    catch (Exception e) {
                        String msg = MessageFormat.format("Instrumentation error for {0} in {1}: {2}", sig.toString(), ParameterizedPreparedStatementPointCut.class.getName(), e.toString());
                        if (ParameterizedPreparedStatementPointCut.this.getLogger().isLoggable(Level.FINEST)) {
                            ParameterizedPreparedStatementPointCut.this.getLogger().log(Level.FINEST, msg, e);
                        }
                        ParameterizedPreparedStatementPointCut.this.getLogger().log(Level.FINE, msg);
                    }
                }
            };
        }
        return null;
    }
}

