/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.database.DefaultDatabaseStatementParser;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.AbstractPreparedStatementPointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.DefaultStatementData;
import com.newrelic.agent.instrumentation.pointcuts.database.GenericPreparedStatementPointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.SqlStatementTracer;
import com.newrelic.agent.instrumentation.pointcuts.database.StatementData;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.lang.reflect.Field;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

@PointCut
public class OraclePreparedStatementPointCut
extends AbstractPreparedStatementPointCut {
    private static final String NAME = "jdbc_oracle_prepared_statement";
    private static final String ORACLE_PREPARED_STATEMENT_CLASS_NAME_MATCH = "oracle/jdbc/driver/OraclePreparedStatement";
    private static final String ORACLE_CALLABLE_STATEMENT_CLASS_NAME_MATCH = "oracle/jdbc/driver/OracleCallableStatement";
    private static final String ORACLE_STATEMENT_CLASS_NAME = "oracle.jdbc.driver.OracleStatement";
    private static final String ORACLE_PREPARED_STATEMENT_CLASS_NAME = "oracle.jdbc.driver.OraclePreparedStatement";
    private static final String ORACLE_CALLABLE_STATEMENT_CLASS_NAME = "oracle.jdbc.driver.OracleCallableStatement";
    private static final String OJDBC14_STATEMENT_ORACLE_SQL_FIELD = "m_sql";
    private static final String OJDBC5_STATEMENT_ORACLE_SQL_FIELD = "sqlObject";
    private static final String OLD_OJDBC14_STATEMENT_ORACLE_SQL_FIELD = "sql_query";
    private static final String ORACLE_SQL_FIELD = "originalSql";
    private final DefaultDatabaseStatementParser databaseStatementParser;

    public OraclePreparedStatementPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration(NAME, null, true), OrClassMatcher.getClassMatcher(new ExactClassMatcher(ORACLE_PREPARED_STATEMENT_CLASS_NAME_MATCH), new ExactClassMatcher(ORACLE_CALLABLE_STATEMENT_CLASS_NAME_MATCH)), GenericPreparedStatementPointCut.METHOD_MATCHER);
        AgentConfig agentConfig = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        this.databaseStatementParser = new DefaultDatabaseStatementParser(agentConfig);
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object statement, Object[] args) {
        Tracer parent = transaction.getLastTracer();
        if (parent != null && parent instanceof OraclePreparedStatementTracer) {
            return null;
        }
        String sql = this.getSql(transaction, sig, statement);
        DefaultStatementData statementData = new DefaultStatementData(this.databaseStatementParser, (Statement)statement, sql, true){

            protected ResultSetMetaData getResultSetMetaData(Object returnValue) throws SQLException {
                return null;
            }
        };
        return new OraclePreparedStatementTracer(transaction, sig, statement, statementData);
    }

    protected String findSql(Transaction transaction, ClassMethodSignature sig, Object statement) throws Exception {
        Field field = null;
        Class<?> statementClass = statement.getClass().getClassLoader().loadClass(ORACLE_STATEMENT_CLASS_NAME);
        Class<?> preparedStatementClass = statementClass.getClassLoader().loadClass(ORACLE_PREPARED_STATEMENT_CLASS_NAME);
        Class<?> callableStatementClass = statementClass.getClassLoader().loadClass(ORACLE_CALLABLE_STATEMENT_CLASS_NAME);
        Class<?> clazz = statement.getClass();
        if (clazz.equals(callableStatementClass) || clazz.equals(preparedStatementClass)) {
            field = statementClass.getDeclaredField(OLD_OJDBC14_STATEMENT_ORACLE_SQL_FIELD);
            field.setAccessible(true);
            return (String)field.get(statement);
        }
        try {
            field = statementClass.getDeclaredField(OJDBC5_STATEMENT_ORACLE_SQL_FIELD);
        }
        catch (NoSuchFieldException e) {
            field = statementClass.getDeclaredField(OJDBC14_STATEMENT_ORACLE_SQL_FIELD);
        }
        field.setAccessible(true);
        Object obj = field.get(statement);
        Field field2 = field.getType().getDeclaredField(ORACLE_SQL_FIELD);
        field2.setAccessible(true);
        return (String)field2.get(obj);
    }

    private class OraclePreparedStatementTracer
    extends SqlStatementTracer {
        public OraclePreparedStatementTracer(Transaction transaction, ClassMethodSignature sig, Object statement, StatementData statementData) {
            super(transaction, sig, statement, statementData);
        }
    }
}

