/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.database.ParsedDatabaseStatement;
import com.newrelic.agent.instrumentation.pointcuts.database.StatementData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.regex.Pattern;

public abstract class DefaultStatementData
implements StatementData {
    private final String sqlForExplainPlan;
    private final Statement statement;
    private final boolean explainSupported;
    private final DatabaseStatementParser databaseStatementParser;
    private ParsedDatabaseStatement parsedDatabaseStatement;
    private final String sql;
    static final Pattern SPLIT_STATEMENT_PATTERN = Pattern.compile(";");

    public DefaultStatementData(DatabaseStatementParser databaseStatementParser, Statement statement, String sql, boolean explainSupported) {
        this.databaseStatementParser = databaseStatementParser;
        this.sql = this.sqlForExplainPlan = sql;
        this.statement = statement;
        this.explainSupported = explainSupported;
    }

    static String getFirstSqlStatement(String sql) {
        int index = sql.indexOf(59);
        if (index > 0) {
            return sql.substring(0, index);
        }
        return sql;
    }

    public String getSqlForExplainPlan() {
        return this.sqlForExplainPlan;
    }

    public String getSql() {
        return this.sql;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public boolean isExplainSupported() {
        return this.explainSupported;
    }

    protected abstract ResultSetMetaData getResultSetMetaData(Object var1) throws SQLException;

    public ParsedDatabaseStatement getParsedStatement(Object returnValue) {
        if (this.parsedDatabaseStatement == null) {
            ResultSetMetaData metaData;
            block3: {
                metaData = null;
                try {
                    metaData = this.getResultSetMetaData(returnValue);
                }
                catch (Exception e) {
                    if (!Agent.isDebugEnabled()) break block3;
                    Agent.LOG.log(Level.FINER, "Unable to get the result set meta data from a statement", e);
                }
            }
            this.parsedDatabaseStatement = this.databaseStatementParser.getParsedDatabaseStatement(this.getSql(), metaData);
        }
        return this.parsedDatabaseStatement;
    }
}

