/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.pointcuts.database.ExplainPlanExecutor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.logging.Level;

public abstract class DefaultExplainPlanExecutor
implements ExplainPlanExecutor {
    private Object originalSqlStatement;

    public DefaultExplainPlanExecutor(String originalSqlStatement) {
        this.originalSqlStatement = originalSqlStatement;
    }

    protected Object[] getExplainPlanFromResultSet(ResultSet rs) throws SQLException {
        int columnCount = rs.getMetaData().getColumnCount();
        if (columnCount > 0) {
            LinkedList explains = new LinkedList();
            while (rs.next()) {
                LinkedList<String> values = new LinkedList<String>();
                for (int i = 1; i <= columnCount; ++i) {
                    Object obj = rs.getObject(i);
                    values.add(obj == null ? "" : obj.toString());
                }
                explains.add(values);
            }
            return new Object[]{explains};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runExplainPlan(Connection connection, ExplainPlanExecutor.DatabaseVendor vendor) throws SQLException {
        String sql = null;
        try {
            sql = this.getExplainSql(vendor);
        }
        catch (SQLException e) {
            this.setExplainPlan(new String[]{e.getMessage()});
            return;
        }
        Agent.LOG.finer("Running explain: " + sql);
        ResultSet resultSet = null;
        Statement statement = null;
        Object[] explainPlan = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            explainPlan = this.getExplainPlanFromResultSet(resultSet);
        }
        catch (Exception e) {
            explainPlan = new Object[]{"An error occurred running explain plan : " + e.getMessage()};
            Agent.LOG.log(Level.FINER, "explain plan error", e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.FINER, "Unable to close result set", e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.FINER, "Unable to close statement", e);
                }
            }
        }
        if (explainPlan != null) {
            this.setExplainPlan(explainPlan);
        }
    }

    protected abstract void setExplainPlan(Object[] var1);

    public String getExplainSql(ExplainPlanExecutor.DatabaseVendor vendor) throws SQLException {
        switch (vendor) {
            case ORACLE: {
                return "EXPLAIN PLAN FOR " + this.originalSqlStatement;
            }
            case DERBY: {
                throw new SQLException("Unable to run explain plans for Derby databases");
            }
            case DB2: {
                throw new SQLException("Unable to run explain plans for DB2 databases");
            }
            case MICROSOFT: {
                throw new SQLException("Unable to run explain plans for SQL Server databases");
            }
        }
        return "EXPLAIN " + this.originalSqlStatement;
    }
}

