/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.pointcuts.database.ExplainPlanExecutor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class DatabaseUtils {
    private static final Pattern DERBY_PATTERN = Pattern.compile("(?i).*derby.*");
    private static final Pattern MYSQL_PATTERN = Pattern.compile("(?i).*mysql.*");
    private static final Pattern POSTGRES_PATTERN = Pattern.compile("(?i).*postgres.*");
    private static final Pattern ORACLE_PATTERN = Pattern.compile("(?i).*oracle.*");
    private static final Pattern DB2_PATTERN = Pattern.compile("(?i).*db2.*");
    private static final Pattern MICROSOFT_PATTERN = Pattern.compile("(?i).*microsoft.*");

    public static ExplainPlanExecutor.DatabaseVendor getDatabaseVendor(Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String databaseProductName = metaData.getDatabaseProductName();
            if (databaseProductName == null) {
                return ExplainPlanExecutor.DatabaseVendor.UNKNOWN;
            }
            if (MYSQL_PATTERN.matcher(databaseProductName).matches()) {
                return ExplainPlanExecutor.DatabaseVendor.MYSQL;
            }
            if (DERBY_PATTERN.matcher(databaseProductName).matches()) {
                return ExplainPlanExecutor.DatabaseVendor.DERBY;
            }
            if (ORACLE_PATTERN.matcher(databaseProductName).matches()) {
                return ExplainPlanExecutor.DatabaseVendor.ORACLE;
            }
            if (DB2_PATTERN.matcher(databaseProductName).matches()) {
                return ExplainPlanExecutor.DatabaseVendor.DB2;
            }
            if (POSTGRES_PATTERN.matcher(databaseProductName).matches()) {
                return ExplainPlanExecutor.DatabaseVendor.POSTGRES;
            }
            if (MICROSOFT_PATTERN.matcher(databaseProductName).matches()) {
                return ExplainPlanExecutor.DatabaseVendor.MICROSOFT;
            }
        }
        catch (SQLException e) {
            Agent.LOG.log(Level.FINER, "Unable to determine database vendor", e);
        }
        return ExplainPlanExecutor.DatabaseVendor.UNKNOWN;
    }
}

