/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.database.DefaultDatabaseStatementParser;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InstanceMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.database.DefaultStatementData;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DatabaseTracer;
import com.newrelic.agent.tracers.MethodExitTracerNoSkip;
import com.newrelic.agent.tracers.Tracer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PointCut
public class CreatePreparedStatementPointCut
extends TracerFactoryPointCut {
    private static final String OBJECT_MAP_KEY = CreatePreparedStatementPointCut.class.getName().intern();
    public static final String CONNECTION_INTERFACE = "java/sql/Connection";
    private static final String MYSQL_CONNECTION_CLASS = "com/mysql/jdbc/Connection";
    private static final MethodMatcher METHOD_MATCHER = new InstanceMethodMatcher(OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher("prepareStatement", "(Ljava/lang/String;)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;III)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;II)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;I)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;"), new ExactMethodMatcher("prepareCall", "(Ljava/lang/String;)Ljava/sql/CallableStatement;", "(Ljava/lang/String;II)Ljava/sql/CallableStatement;", "(Ljava/lang/String;III)Ljava/sql/CallableStatement;")));
    final DatabaseStatementParser sqlParser;

    public CreatePreparedStatementPointCut(ClassTransformer classTransformer) {
        this(ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig());
    }

    private CreatePreparedStatementPointCut(AgentConfig config) {
        super(new PointCutConfiguration("jdbc_prepare_statement", null, CreatePreparedStatementPointCut.isEnabledByDefault()), CreatePreparedStatementPointCut.getClassMatcher(config), METHOD_MATCHER);
        this.sqlParser = new DefaultDatabaseStatementParser(config);
    }

    protected static boolean isEnabledByDefault() {
        Set<String> jdbcSupport = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().getJDBCSupport();
        return jdbcSupport.size() != 1 || !jdbcSupport.contains("mysql");
    }

    private static ClassMatcher getClassMatcher(AgentConfig agentConfig) {
        ArrayList<ClassMatcher> matchers = new ArrayList<ClassMatcher>(2);
        if (agentConfig.isGenericJDBCSupportEnabled()) {
            matchers.add(new InterfaceMatcher(CONNECTION_INTERFACE));
        }
        if (agentConfig.getJDBCSupport().contains("mysql")) {
            matchers.add(new ExactClassMatcher(MYSQL_CONNECTION_CLASS));
        }
        return OrClassMatcher.getClassMatcher(matchers.toArray(new ClassMatcher[0]));
    }

    public static DefaultStatementData getPreparedStatementSql(Transaction transaction, PreparedStatement statement) {
        Map<PreparedStatement, DefaultStatementData> preparedStatementTracker = CreatePreparedStatementPointCut.getObjectTracker(transaction);
        return preparedStatementTracker.get(statement);
    }

    static Map<PreparedStatement, DefaultStatementData> getObjectTracker(Transaction transaction) {
        return transaction.getObjectMap(OBJECT_MAP_KEY);
    }

    @Override
    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object connection, Object[] args) {
        String sql;
        if (transaction.getLastTracer() instanceof CreatePreparedStatementTracer) {
            return null;
        }
        String string = sql = args.length > 0 ? (String)args[0] : null;
        if (sql != null) {
            return new CreatePreparedStatementTracer(transaction, sig, connection, sql);
        }
        return null;
    }

    private class CreatePreparedStatementTracer
    extends MethodExitTracerNoSkip
    implements DatabaseTracer {
        private String sql;

        public CreatePreparedStatementTracer(Transaction transaction, ClassMethodSignature sig, Object connection, String sql) {
            super(sig, transaction);
            this.sql = sql;
        }

        protected void doFinish(int opcode, Object statement) {
            if (statement instanceof PreparedStatement) {
                PreparedStatementData statementData = new PreparedStatementData(CreatePreparedStatementPointCut.this.sqlParser, (Statement)statement, this.sql, false);
                CreatePreparedStatementPointCut.getObjectTracker(this.getTransaction()).put((PreparedStatement)statement, statementData);
            }
            this.sql = null;
        }
    }

    public static final class PreparedStatementData
    extends DefaultStatementData {
        public PreparedStatementData(DatabaseStatementParser databaseStatementParser, Statement statement, String sql, boolean explainSupported) {
            super(databaseStatementParser, statement, sql, explainSupported);
        }

        protected ResultSetMetaData getResultSetMetaData(Object returnValue) throws SQLException {
            if (returnValue instanceof ResultSet) {
                return ((ResultSet)returnValue).getMetaData();
            }
            return null;
        }
    }
}

