/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PointCut
public class BatchSqlPointCut
extends TracerFactoryPointCut {
    private static final String OBJECT_MAP_KEY = BatchSqlPointCut.class.getName().intern();

    public BatchSqlPointCut(ClassTransformer classTransformer) {
        super(BatchSqlPointCut.class, (ClassMatcher)new InterfaceMatcher("java/sql/Statement"), BatchSqlPointCut.createMethodMatcher(new ExactMethodMatcher("addBatch", "(Ljava/lang/String;)V"), new ExactMethodMatcher("executeBatch", "()[I")));
    }

    private static Map<Statement, List<String>> getObjectTracker(Transaction transaction) {
        return transaction.getObjectMap(OBJECT_MAP_KEY);
    }

    @Override
    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object statementObj, Object[] args) {
        Statement statement = (Statement)statementObj;
        Map<Statement, List<String>> statementTracker = BatchSqlPointCut.getObjectTracker(transaction);
        List<String> list = statementTracker.get(statement);
        if ("addBatch".equals(sig.getMethodName())) {
            if (list == null) {
                list = new LinkedList<String>();
                statementTracker.put(statement, list);
            }
            list.add((String)args[0]);
        } else if ("executeBatch".equals(sig.getMethodName()) && Agent.isDebugEnabled()) {
            System.err.println("Execute batch " + list);
        }
        return null;
    }
}

