/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPreparedStatementPointCut
extends TracerFactoryPointCut {
    private static final String PARAMETER_REGEX = "\\?";
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\?");
    private final Logger logger = Agent.LOG.getChildLogger(this.getClass());

    protected AbstractPreparedStatementPointCut(PointCutConfiguration config, ClassMatcher classMatcher, MethodMatcher methodMatcher) {
        super(config, classMatcher, methodMatcher);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected String getSql(Transaction transaction, ClassMethodSignature sig, Object statement) {
        String sql = null;
        try {
            sql = this.findSql(transaction, sig, statement);
            if (sql == null) {
                String msg = MessageFormat.format("No SQL found for {0} in {1}", statement, this.getClass().getName());
                this.logger.log(Level.FINE, msg);
            } else if ("raw" == transaction.getTransactionTracerConfig().getRecordSql()) {
                sql = AbstractPreparedStatementPointCut.parameterizeSql(sql, this.getParameterMap(statement));
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Instrumentation error for {0} invoking {1} in {2}: {3}", statement, sig, this.getClass().getName(), e);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, msg, e);
            }
            this.logger.log(Level.FINE, msg);
        }
        return sql;
    }

    protected abstract String findSql(Transaction var1, ClassMethodSignature var2, Object var3) throws Exception;

    protected Map<Integer, Object> getOrCreateParameterMap(Object statement) throws Exception {
        return this.getParameterMap(statement, true);
    }

    protected Map<Integer, Object> getParameterMap(Object statement) throws Exception {
        return this.getParameterMap(statement, false);
    }

    private Map<Integer, Object> getParameterMap(Object statement, boolean createIfAbsent) throws Exception {
        Field field = this.getField(statement);
        field.setAccessible(true);
        HashMap parameterMap = (HashMap)field.get(statement);
        if (parameterMap == null) {
            parameterMap = new HashMap();
            field.set(statement, parameterMap);
        }
        return parameterMap;
    }

    private Field getField(Object statement) throws NoSuchFieldException {
        Class<?> clazz = statement.getClass();
        Field field = null;
        while (field == null) {
            try {
                field = clazz.getDeclaredField("_nr_sql_parameters");
            }
            catch (NoSuchFieldException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw e;
            }
        }
        return field;
    }

    public static String parameterizeSql(String sql, Map<Integer, Object> parameters) throws Exception {
        if (sql == null || parameters == null || parameters.isEmpty()) {
            return sql;
        }
        String[] pieces = PARAMETER_PATTERN.split(sql);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int j = 1;
        while (i < pieces.length) {
            String piece = pieces[i];
            if (j == pieces.length && sql.endsWith(piece)) {
                sb.append(piece);
            } else {
                Object val = parameters.get(j);
                if (val == null) {
                    sb.append(piece).append("?");
                } else {
                    sb.append(piece).append("'").append(val.toString()).append("'");
                }
            }
            ++i;
            ++j;
        }
        return sb.toString();
    }
}

