/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.weblogic;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherPointCut;
import com.newrelic.agent.tracers.servlet.GenericRequest;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.HttpResponse;
import java.lang.reflect.Method;

@PointCut
public class WebLogicDispatcherPointCut
extends BasicRequestDispatcherPointCut {
    public WebLogicDispatcherPointCut(ClassTransformer classTransformer) {
        super(WebLogicDispatcherPointCut.class, (ClassMatcher)new ExactClassMatcher("weblogic/servlet/internal/WebAppServletContext"), WebLogicDispatcherPointCut.createExactMethodMatcher("execute", "(Lweblogic/servlet/internal/ServletRequestImpl;Lweblogic/servlet/internal/ServletResponseImpl;)V"));
    }

    protected HttpRequest getRequest(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        return new GenericRequest(args[0], args[0].getClass());
    }

    protected HttpResponse getResponse(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        final Object response = args[1];
        return new HttpResponse(){

            public int getResponseStatus() throws Exception {
                Method method = response.getClass().getMethod("getStatus", new Class[0]);
                method.setAccessible(true);
                return (Integer)method.invoke(response, new Object[0]);
            }

            public String getResponseStatusMessage() throws Exception {
                return null;
            }
        };
    }
}

