/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.tomcat;

import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.container.SystemSamplerPointCut;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.util.CleverClassLoader;

@PointCut
public class TomcatServerPointCut
extends SystemSamplerPointCut {
    public TomcatServerPointCut(ClassTransformer classTransformer) {
        super(new PointCutConfiguration(TomcatServerPointCut.class.getName(), "tomcat_instrumentation", true), (ClassMatcher)new ExactClassMatcher("org/apache/catalina/core/StandardServer"), TomcatServerPointCut.createExactMethodMatcher("start", "()V"));
    }

    protected MetricSampler getSampler(Object server, String serverClassName) throws Exception {
        CleverClassLoader cl = new CleverClassLoader(server.getClass().getClassLoader());
        Class listenerClazz = cl.loadClassSpecial("com.newrelic.agent.instrumentation.pointcuts.container.tomcat.TomcatSampler");
        return (MetricSampler)listenerClazz.getConstructor(Object.class).newInstance(server);
    }

    protected String getServerName() {
        return "Apache Tomcat";
    }
}

