/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.jetty;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.AJettyPointCut;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.JettyResponse;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherTracer;
import com.newrelic.agent.tracers.servlet.HttpRequest;
import com.newrelic.agent.tracers.servlet.RequestDispatcherTracerFactory;
import com.newrelic.agent.util.Invoker;
import com.newrelic.agent.util.ServletUtils;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

@PointCut
public class JettyServer5DispatcherPointCut
extends AJettyPointCut {
    private static final String HTTP_SERVLET_REQUEST_INTERFACE = "javax.servlet.http.HttpServletRequest";

    public JettyServer5DispatcherPointCut(ClassTransformer classTransformer) {
        super("jetty_5_dispatcher", (TracerFactory)new DispatcherTracerFactory(), (ClassMatcher)new ExactClassMatcher("org/mortbay/http/HttpServer"), JettyServer5DispatcherPointCut.createExactMethodMatcher("service", "(Lorg/mortbay/http/HttpRequest;Lorg/mortbay/http/HttpResponse;)Lorg/mortbay/http/HttpContext;"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JettyRequest
    implements HttpRequest {
        private final Object request;

        public JettyRequest(Object request) {
            this.request = request;
        }

        @Override
        public String getHeader(String name) throws Exception {
            Object servletRequest = Invoker.invoke(this.request, "org.mortbay.http.HttpRequest", "getWrapper", new Object[0]);
            return (String)Invoker.invoke(servletRequest, JettyServer5DispatcherPointCut.HTTP_SERVLET_REQUEST_INTERFACE, "getHeader", name);
        }

        @Override
        public Map getRequestParameterMap(Set<String> excludes) throws Exception {
            return ServletUtils.getFilteredParameterMap((Map)this.request.getClass().getMethod("getParameterStringArrayMap", new Class[0]).invoke(this.request, new Object[0]), excludes);
        }

        @Override
        public String getRequestURI() throws Exception {
            String requestUri = this.request.getClass().getMethod("getURI", new Class[0]).invoke(this.request, new Object[0]).toString();
            return requestUri;
        }
    }

    private static class DispatcherTracerFactory
    extends RequestDispatcherTracerFactory {
        private DispatcherTracerFactory() {
        }

        protected Tracer getTracerImpl(Transaction transaction, ClassMethodSignature sig, Object server, Object[] args) {
            try {
                return new BasicRequestDispatcherTracer(transaction, sig, server, new JettyRequest(args[0]), new JettyResponse(args[1]));
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINE, "Unable to create Jetty dispatcher tracer", e);
                return null;
            }
        }
    }
}

