/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.jetty;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JettySampler
implements MetricSampler {
    private final Object server;
    private boolean firstError = true;

    public JettySampler(Object server) throws Exception {
        this.server = server;
        this.enableConnectorStats();
        this.getVersionFromServer(server);
        try {
            Object port;
            Object[] serverConnectors = this.getServerConnectors();
            if (serverConnectors.length > 0 && (port = this.getConnectorClass().getMethod("getPort", new Class[0]).invoke(serverConnectors[0], new Object[0])) instanceof Integer) {
                ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMService().setApplicationServerPort((Integer)port);
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "Unable to record the Jetty server port", e);
        }
    }

    protected void getVersionFromServer(Object server) {
        try {
            String version = (String)server.getClass().getMethod("getVersion", new Class[0]).invoke(server, new Object[0]);
            ServiceManagerFactory.getServiceManager().getEnvironmentService().getEnvironment().setDispatcherVersion(version);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "Unable to record Jetty version", e);
        }
    }

    protected void enableConnectorStats() throws Exception {
        Method setStatsOn = this.getConnectorClass().getMethod("setStatsOn", Boolean.TYPE);
        for (Object connector : this.getServerConnectors()) {
            setStatsOn.invoke(connector, true);
        }
    }

    protected final Object getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sample() {
        try {
            Object connector;
            Object[] connectors;
            HashMap<String, Double> metricValues = new HashMap<String, Double>();
            int acceptorThreadCount = 0;
            Object[] arr$ = connectors = this.getServerConnectors();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; acceptorThreadCount += ((Number)connector.getClass().getMethod("getAcceptors", new Class[0]).invoke(connector, new Object[0])).intValue(), ++i$) {
                connector = arr$[i$];
            }
            Object threadPool = this.server.getClass().getMethod("getThreadPool", new Class[0]).invoke(this.server, new Object[0]);
            if (threadPool != null) {
                double busyThreads;
                double totalThreads;
                String name = threadPool.getClass().getSimpleName();
                if (threadPool instanceof ThreadPoolExecutor) {
                    ThreadPoolExecutor executor = (ThreadPoolExecutor)threadPool;
                    totalThreads = executor.getMaximumPoolSize();
                    busyThreads = executor.getActiveCount();
                } else {
                    Number maxThreadCount = (Number)threadPool.getClass().getMethod("getMaxThreads", new Class[0]).invoke(threadPool, new Object[0]);
                    Number threadCount = (Number)threadPool.getClass().getMethod("getThreads", new Class[0]).invoke(threadPool, new Object[0]);
                    Number idleCount = (Number)threadPool.getClass().getMethod("getIdleThreads", new Class[0]).invoke(threadPool, new Object[0]);
                    totalThreads = maxThreadCount.doubleValue();
                    busyThreads = threadCount.doubleValue() - idleCount.doubleValue();
                }
                metricValues.put(MessageFormat.format("RequestThreads/{0}/total", name), totalThreads -= (double)acceptorThreadCount);
                metricValues.put(MessageFormat.format("RequestThreads/{0}/busy", name), busyThreads -= (double)acceptorThreadCount);
                double busyPercentage = busyThreads / totalThreads;
                metricValues.put("Instance/Busy", busyPercentage);
            }
            List<IRPMService> rpmServices = ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMServices();
            for (IRPMService rpmService : rpmServices) {
                StatsEngine statsEngine = rpmService.getStatsEngine();
                Object object = statsEngine.getHarvestLock();
                synchronized (object) {
                    for (Map.Entry metricValue : metricValues.entrySet()) {
                        statsEngine.getStats((String)metricValue.getKey()).recordDataPoint(((Number)metricValue.getValue()).floatValue());
                    }
                }
            }
            return;
        }
        catch (Throwable t) {
            if (this.firstError) {
                this.firstError = false;
                Agent.LOG.severe("Unable to sample Jetty system: " + t.toString());
            }
            Agent.LOG.log(Level.FINE, "Unable to sample Jetty system", t);
        }
    }

    protected abstract Class<?> getConnectorClass() throws ClassNotFoundException;

    protected String getConnectorsMethodName() {
        return "getConnectors";
    }

    private Object[] getServerConnectors() throws Exception {
        return (Object[])this.server.getClass().getMethod(this.getConnectorsMethodName(), new Class[0]).invoke(this.server, new Object[0]);
    }
}

