/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.jetty;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.JettyResponse;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.servlet.BasicRequestDispatcherTracer;
import com.newrelic.agent.tracers.servlet.GenericRequest;
import com.newrelic.agent.tracers.servlet.RequestDispatcherTracerFactory;
import com.newrelic.agent.util.ServletUtils;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class JettyDispatcherTracerFactory
extends RequestDispatcherTracerFactory {
    private static final String GET_REQUEST_URI_METHOD_NAME = "getRequestURI";

    protected Tracer getTracerImpl(Transaction transaction, ClassMethodSignature sig, Object server, Object[] args) {
        try {
            return new JettyDispatcherTracer(transaction, sig, server, args[0]);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "Unable to create Jetty dispatcher tracer", e);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JettyRequest
    extends GenericRequest {
        public JettyRequest(Object request) {
            super(request);
        }

        @Override
        public Map getRequestParameterMap(Set<String> excludes) throws Exception {
            return ServletUtils.getFilteredParameterMap((Map)this.getRequest().getClass().getMethod("getParameterMap", new Class[0]).invoke(this.getRequest(), new Object[0]), excludes);
        }

        @Override
        public String getRequestURI() throws Exception {
            return (String)this.getRequest().getClass().getMethod(JettyDispatcherTracerFactory.GET_REQUEST_URI_METHOD_NAME, new Class[0]).invoke(this.getRequest(), new Object[0]);
        }
    }

    public static class JettyDispatcherTracer
    extends BasicRequestDispatcherTracer {
        public JettyDispatcherTracer(Transaction transaction, ClassMethodSignature sig, Object server, Object connection) throws Exception {
            super(transaction, sig, server, new JettyRequest(connection.getClass().getMethod("getRequest", new Class[0]).invoke(connection, new Object[0])), new JettyResponse(connection.getClass().getMethod("getResponse", new Class[0]).invoke(connection, new Object[0])));
        }
    }
}

