/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.MethodExitTracer;
import com.newrelic.agent.tracers.Tracer;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SystemSamplerPointCut
extends TracerFactoryPointCut {
    private static final long INITIAL_DELAY_IN_MILLISECONDS = 1000L;
    private static final long DELAY_IN_MILLISECONDS = 5000L;

    protected SystemSamplerPointCut(Class<? extends TracerFactoryPointCut> tracerFactory, ClassMatcher classMatcher, MethodMatcher methodMatcher) {
        super(tracerFactory, classMatcher, methodMatcher);
    }

    protected SystemSamplerPointCut(PointCutConfiguration config, ClassMatcher classMatcher, MethodMatcher methodMatcher) {
        super(config, classMatcher, methodMatcher);
    }

    @Override
    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object server, Object[] args) {
        if (ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().getProperty("enable_server_sampler", true).booleanValue()) {
            return new SystemTracer(sig, server);
        }
        return null;
    }

    protected abstract String getServerName();

    protected abstract MetricSampler getSampler(Object var1, String var2) throws Exception;

    private class SystemTracer
    extends MethodExitTracer {
        private Object server;

        public SystemTracer(ClassMethodSignature sig, Object server) {
            super(sig);
            this.server = server;
            ServiceManagerFactory.getServiceManager().getEnvironmentService().getEnvironment().setDispatcher(SystemSamplerPointCut.this.getServerName());
        }

        protected void doFinish(int opcode, Object returnValue) {
            try {
                Agent.LOG.log(Level.INFO, "Initializing {0} system sampler", SystemSamplerPointCut.this.getServerName());
                MetricSampler sampler = SystemSamplerPointCut.this.getSampler(this.server, this.getClassMethodSignature().getInternalClassName());
                ServiceManagerFactory.getServiceManager().getSamplerService().addMetricSampler(sampler, 1000L, 5000L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                String msg = MessageFormat.format("Unable to initialize a {0} sampler: {1}", SystemSamplerPointCut.this.getServerName(), t.toString());
                if (Agent.LOG.isLoggable(Level.FINER)) {
                    Agent.LOG.log(Level.SEVERE, msg, t);
                }
                Agent.LOG.severe(msg);
            }
        }
    }
}

