/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.commons;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.commons.HostInfo;
import com.newrelic.agent.instrumentation.pointcuts.commons.HttpCommonsPointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.Invoker;
import com.newrelic.agent.util.Strings;
import java.util.logging.Level;

@PointCut
public class HttpMethodPointCut
extends HttpCommonsPointCut {
    static final String UNKNOWN_HOST_METRIC_NAME = "CommonsHttp/Unknown";

    public HttpMethodPointCut(ClassTransformer classTransformer) {
        super((Class<? extends HttpCommonsPointCut>)HttpMethodPointCut.class, (ClassMatcher)new InterfaceMatcher(HostInfo.HTTP_METHOD_CLASS_NAME.replace('.', '/')), HttpMethodPointCut.createExactMethodMatcher("execute", "(Lorg/apache/commons/httpclient/HttpState;Lorg/apache/commons/httpclient/HttpConnection;)I"));
    }

    protected Tracer getTracerImpl(Transaction transaction, ClassMethodSignature sig, Object httpMethod, Object[] args) {
        try {
            final String hostName = (String)Invoker.invoke(args[1], Strings.fixClassName("com.newrelic.org.apache.commons.httpclient.HttpConnection"), "getHost", new Object[0]);
            HostInfo info = new HostInfo(){

                public String getHost() {
                    return hostName;
                }
            };
            return super.getTracer(transaction, sig, httpMethod, info);
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINER, "Unable to get host from HttpConnection", t);
            return null;
        }
    }
}

