/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.commons;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InstanceMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.commons.BasicHostInfo;
import com.newrelic.agent.instrumentation.pointcuts.commons.HttpCommonsPointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import java.util.logging.Level;

@PointCut
public class HttpClientPointCut
extends HttpCommonsPointCut {
    private static final String METHOD_SIGNATURE_1 = "(Lorg/apache/commons/httpclient/HttpMethod;)I";
    private static final String METHOD_SIGNATURE_2 = "(Lorg/apache/commons/httpclient/HostConfiguration;Lorg/apache/commons/httpclient/HttpMethod;)I";
    private static final String METHOD_SIGNATURE_3 = "(Lorg/apache/commons/httpclient/HostConfiguration;Lorg/apache/commons/httpclient/HttpMethod;Lorg/apache/commons/httpclient/HttpState;)I";

    public HttpClientPointCut(ClassTransformer classTransformer) {
        super((Class<? extends HttpCommonsPointCut>)HttpClientPointCut.class, (ClassMatcher)new ExactClassMatcher("com/newrelic/org/apache/commons/httpclient/HttpClient"), (MethodMatcher)new InstanceMethodMatcher(OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher("executeMethod", METHOD_SIGNATURE_1, METHOD_SIGNATURE_2, METHOD_SIGNATURE_3))));
    }

    protected Tracer getTracerImpl(Transaction transaction, ClassMethodSignature sig, Object httpClient, Object[] args) {
        Object httpMethod;
        Object hostConfig = null;
        if (sig.getMethodDesc() == METHOD_SIGNATURE_1) {
            httpMethod = args[0];
            try {
                hostConfig = httpClient.getClass().getMethod("getHostConfiguration", new Class[0]).invoke(httpClient, new Object[0]);
            }
            catch (Throwable e) {
                Agent.LOG.log(Level.FINER, e.toString(), e);
            }
        } else {
            hostConfig = args[0];
            httpMethod = args[1];
        }
        return super.getTracer(transaction, sig, httpClient, new BasicHostInfo(hostConfig, httpMethod));
    }
}

