/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.commons;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.pointcuts.commons.HostInfo;
import com.newrelic.agent.util.Invoker;
import java.lang.reflect.Field;
import java.util.logging.Level;

public class BasicHostInfo
implements HostInfo {
    private final Object hostConfig;
    private final Object httpMethod;

    public BasicHostInfo(Object hostConfig, Object httpMethod) {
        this.hostConfig = hostConfig;
        this.httpMethod = httpMethod;
    }

    public String getHost() {
        if (this.hostConfig == null) {
            if (this.httpMethod == null) {
                return "Unknown";
            }
            try {
                Class<?> baseClass = this.httpMethod.getClass().getClassLoader().loadClass("com.newrelic.org.apache.commons.httpclient.HttpMethodBase");
                Field field = baseClass.getDeclaredField("responseConnection");
                field.setAccessible(true);
                Object connection = field.get(this.httpMethod);
                return (String)connection.getClass().getDeclaredMethod("getHost", new Class[0]).invoke(connection, new Object[0]);
            }
            catch (Throwable t) {
                this.log(t);
                return "Unknown";
            }
        }
        try {
            Object host = this.hostConfig.getClass().getMethod("getHost", new Class[0]).invoke(this.hostConfig, new Object[0]);
            if (host != null) {
                return host.toString();
            }
            if (this.httpMethod == null) {
                return "Unknown";
            }
            Object uri = Invoker.invoke(this.httpMethod, HTTP_METHOD_CLASS_NAME, "getURI", new Object[0]);
            if (uri != null && (host = uri.getClass().getMethod("getHost", new Class[0]).invoke(uri, new Object[0])) != null) {
                return host.toString();
            }
        }
        catch (Throwable e) {
            this.log(e);
        }
        return "Unknown";
    }

    private void log(Throwable t) {
        Agent.LOG.finer(t.toString());
        Agent.LOG.log(Level.FINEST, "HttpCommonsPointCut exception", t);
    }
}

