/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.classmatchers;

import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.util.Strings;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.Type;

public class ChildClassMatcher
extends ClassMatcher {
    private final String internalSuperClassName;
    private final String superClassName;
    private final boolean onlyMatchChildren;

    public ChildClassMatcher(String superClassName) {
        this(superClassName, true);
    }

    public ChildClassMatcher(String superClassName, boolean onlyMatchChildren) {
        superClassName = Strings.fixInternalClassName(superClassName);
        if (superClassName.indexOf(47) < 0) {
            throw new RuntimeException("Invalid class name format");
        }
        this.superClassName = Type.getObjectType(superClassName).getClassName();
        this.internalSuperClassName = superClassName;
        this.onlyMatchChildren = onlyMatchChildren;
    }

    public boolean isMatch(ClassLoader loader, String className, ClassReader cr) {
        if (className.equals(this.superClassName)) {
            return !this.onlyMatchChildren;
        }
        String superName = cr.getSuperName();
        return superName.equals(this.internalSuperClassName);
    }

    public boolean isMatch(Class clazz) {
        if (clazz.getName().equals(this.superClassName)) {
            return !this.onlyMatchChildren;
        }
        while ((clazz = clazz.getSuperclass()) != null) {
            if (!clazz.getName().equals(this.superClassName)) continue;
            return true;
        }
        return false;
    }

    public boolean isNotMatch(ClassLoader loader, String className, ClassReader cr) {
        return className.equals(this.internalSuperClassName) && this.onlyMatchChildren;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.internalSuperClassName == null ? 0 : this.internalSuperClassName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChildClassMatcher other = (ChildClassMatcher)obj;
        return !(this.internalSuperClassName == null ? other.internalSuperClassName != null : !this.internalSuperClassName.equals(other.internalSuperClassName));
    }
}

