/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.instrumentation.AbstractClassTransformer;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.org.objectweb.asm.ClassAdapter;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.ClassWriter;
import com.newrelic.org.objectweb.asm.FieldVisitor;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCClassTransformer
extends AbstractClassTransformer {
    public static final String SQL_PARAMETERS_FIELD_NAME = "_nr_sql_parameters";
    public static final String SQL_PARAMETERS_FIELD_DESC = "Ljava/util/Map;";
    private static final List<String> DEFAULT_JDBC_STATEMENT_CLASSES;
    private final List<String> jdbcStatementClasses;
    private final ClassTransformer classTransformer;
    private final Logger logger;

    public JDBCClassTransformer(ClassTransformer classTransformer) {
        super(classTransformer.getClassReaderFlags(), ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().isGenericJDBCSupportEnabled());
        this.classTransformer = classTransformer;
        this.logger = Agent.LOG.getChildLogger(ClassTransformer.class);
        List<String> jdbcClasses = JDBCClassTransformer.getJdbcStatementClasses();
        StringBuilder sb = new StringBuilder();
        sb.append("JDBC statement classes: ");
        for (String jdbcClass : jdbcClasses) {
            sb.append("\n").append(jdbcClass);
        }
        this.logger.fine(sb.toString());
        this.jdbcStatementClasses = Collections.unmodifiableList(jdbcClasses);
    }

    public static List<String> getJdbcStatementClasses() {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(DEFAULT_JDBC_STATEMENT_CLASSES);
        result.addAll(JDBCClassTransformer.getJdbcStatementClassesInConfig());
        return Collections.unmodifiableList(result);
    }

    private static List<String> getJdbcStatementClassesInConfig() {
        LinkedList<String> result = new LinkedList<String>();
        ClassTransformerConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().getClassTransformerConfig();
        for (String configClass : config.getJdbcStatements()) {
            result.add(configClass);
        }
        return result;
    }

    @Override
    protected boolean isRetransformSupported() {
        return false;
    }

    @Override
    protected ClassVisitor getClassVisitor(ClassReader cr, ClassWriter cw, String className) {
        return new JDBCClassAdapter(cw);
    }

    @Override
    protected boolean matches(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (classBeingRedefined != null) {
            return false;
        }
        if (this.classTransformer.isExcluded(className)) {
            return false;
        }
        return this.jdbcStatementClasses.contains(className);
    }

    static {
        LinkedList<String> list = new LinkedList<String>();
        list.add("com/mysql/jdbc/PreparedStatement");
        list.add("com/microsoft/sqlserver/jdbc/SQLServerPreparedStatement");
        list.add("net/sourceforge/jtds/jdbc/JtdsPreparedStatement");
        list.add("oracle/jdbc/driver/OracleCallableStatement");
        list.add("oracle/jdbc/driver/OraclePreparedStatement");
        DEFAULT_JDBC_STATEMENT_CLASSES = Collections.unmodifiableList(list);
    }

    private static class JDBCClassAdapter
    extends ClassAdapter {
        private JDBCClassAdapter(ClassVisitor cv) {
            super(cv);
        }

        public void visitEnd() {
            FieldVisitor fv = this.cv.visitField(2, JDBCClassTransformer.SQL_PARAMETERS_FIELD_NAME, JDBCClassTransformer.SQL_PARAMETERS_FIELD_DESC, null, null);
            if (fv != null) {
                fv.visitEnd();
            }
            super.visitEnd();
        }
    }
}

