/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.PointCutConfig;
import com.newrelic.agent.errors.ErrorService;
import com.newrelic.agent.instrumentation.ClassAnnotationVisitor;
import com.newrelic.agent.instrumentation.ClassNameFilter;
import com.newrelic.agent.instrumentation.GenericClassAdapter;
import com.newrelic.agent.instrumentation.InstrumentedClass;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.StartableClassFileTransformer;
import com.newrelic.agent.instrumentation.StopProcessingException;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ManyClassMatcher;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.util.Invoker;
import com.newrelic.agent.util.LatchingRunnable;
import com.newrelic.agent.util.Streams;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassWriter;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Proxy;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTransformer
implements StartableClassFileTransformer {
    private static final String EXCLUDES_FILE = "/META-INF/excludes";
    private final Collection<PointCut> pointcuts;
    private final int classreaderFlags;
    private final boolean debug;
    private final ExecutorService executor;
    private InstrumentationProxy instrumentation;
    private final boolean retransformSupported;
    private ClassNameFilter classNameFilter;
    private boolean agentHandleMethodExists;
    private final Logger logger;

    protected ClassTransformer(InstrumentationProxy instrumentation, boolean retransformSupported) {
        this.instrumentation = instrumentation;
        this.debug = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().isDebugEnabled();
        this.logger = Agent.LOG.getChildLogger(ClassTransformer.class);
        this.executor = Executors.newSingleThreadExecutor(new DefaultThreadFactory("New Relic Class Transformer", true));
        this.classNameFilter = new ClassNameFilter(this.logger);
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        this.addConfigClassFilters(config);
        this.addExcludeFileClassFilters();
        LinkedList<PointCut> pcs = new LinkedList<PointCut>(this.findPointCuts());
        pcs.addAll(PointCutConfig.getExtensionPointCuts());
        pcs.addAll(ErrorService.getErrorHandlerPointCuts());
        for (PointCut pc : pcs.toArray(new PointCut[0])) {
            if (pc.isEnabled()) continue;
            pcs.remove(pc);
        }
        Collections.sort(pcs);
        this.pointcuts = Collections.unmodifiableCollection(pcs);
        for (PointCut pc : this.pointcuts) {
            TracerFactory tracerFactory = pc.getTracerFactory();
            if (tracerFactory != null) {
                ServiceManagerFactory.getServiceManager().getTracerService().registerTracerFactory(pc.getTracerFactoryName(), tracerFactory);
            }
            this.registerClassFilterInclusions(pc.getClassMatcher());
        }
        this.classreaderFlags = instrumentation.getClassReaderFlags();
        this.retransformSupported = retransformSupported;
        this.logger.finer("Class transformer initialized");
    }

    private void addConfigClassFilters(AgentConfig config) {
        String[] includes;
        String[] excludes = config.getClassTransformerConfig().getExcludes();
        if (excludes.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Exclude class name filters:");
            for (String exclude : excludes) {
                sb.append("\n").append(exclude);
                this.classNameFilter.addExclude(exclude);
            }
            this.logger.finer(sb.toString());
        }
        for (String include : includes = config.getClassTransformerConfig().getIncludes()) {
            this.classNameFilter.addInclude(include);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExcludeFileClassFilters() {
        InputStream iStream = this.getClass().getResourceAsStream(EXCLUDES_FILE);
        BufferedReader reader = new BufferedReader(new InputStreamReader(iStream));
        LinkedList<String> excludeList = new LinkedList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                excludeList.add(line);
            }
        }
        catch (IOException ex) {
            this.logger.severe("Unable to read the class excludes file");
        }
        finally {
            try {
                iStream.close();
            }
            catch (IOException e) {}
        }
        for (String exclude : excludeList) {
            this.classNameFilter.addExclude(exclude);
        }
        this.logger.finer("Excludes initialized: " + excludeList);
    }

    Collection<PointCut> findPointCuts() {
        String pointcutAnnotation = 'L' + com.newrelic.agent.instrumentation.pointcuts.PointCut.class.getName().replace('.', '/') + ';';
        Pattern pattern = Pattern.compile("com/newrelic/agent/instrumentation/pointcuts/(.*).class");
        ClassLoader classLoader = ClassTransformer.class.getClassLoader();
        Collection<String> fileNames = AgentJarHelper.findAgentJarFileNames(pattern);
        ArrayList<PointCut> pointcuts = new ArrayList<PointCut>(fileNames.size());
        for (String fileName : fileNames) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                Streams.copy(ClassTransformer.class.getResourceAsStream('/' + fileName), out);
                ClassReader cr = new ClassReader(out.toByteArray());
                Collection<String> annotations = ClassAnnotationVisitor.getAnnotations(cr);
                if (!annotations.contains(pointcutAnnotation)) continue;
                String className = fileName.replace('/', '.');
                int index = className.indexOf(".class");
                if (index > 0) {
                    className = className.substring(0, index);
                }
                Class<PointCut> clazz = classLoader.loadClass(className);
                pointcuts.add(this.createPointCut(clazz));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pointcuts;
    }

    private PointCut createPointCut(Class<PointCut> clazz) {
        try {
            return clazz.getConstructor(ClassTransformer.class).newInstance(this);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.SEVERE, "Unable to create pointcut {0} : {1}", new Object[]{clazz.getName(), e.toString()});
            return null;
        }
    }

    private void registerClassFilterInclusions(ClassMatcher classMatcher) {
        if (classMatcher instanceof ExactClassMatcher) {
            String className = ((ExactClassMatcher)classMatcher).getInternalClassName();
            if (this.classNameFilter.isExcluded(className)) {
                this.classNameFilter.addIncludeClass(className);
            }
        } else if (classMatcher instanceof ManyClassMatcher) {
            for (ClassMatcher matcher : ((ManyClassMatcher)classMatcher).getClassMatchers()) {
                this.registerClassFilterInclusions(matcher);
            }
        }
    }

    @Override
    public void start(InstrumentationProxy instrumentation, boolean isRetransformSupported) {
        instrumentation.addTransformer(this, this.retransformSupported);
        for (PointCut pc : this.pointcuts) {
            pc.noticeTransformerStarted(this);
        }
    }

    void setAgentHandleExists(boolean val) {
        this.agentHandleMethodExists = val;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!this.shouldTransform(loader, className, classfileBuffer)) {
            return null;
        }
        try {
            WeavingLoaderImpl weavingLoader = this.getWeavingLoader(loader);
            return weavingLoader.preProcess(className, classBeingRedefined, classfileBuffer);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            this.logger.severe(MessageFormat.format("An error occurred processing class {0} : {1}", className, e.toString()));
            if (Agent.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private boolean shouldTransform(ClassLoader loader, String className, byte[] classfileBuffer) {
        if (this.isExcluded(className)) {
            return false;
        }
        if (className.startsWith("$") || className.indexOf("$$") > 0) {
            if (Agent.isDebugEnabled()) {
                this.logger.log(Level.FINER, "Skipping class {0} ({1})", new Object[]{className, loader == null ? "" : loader.getClass().getName()});
            }
            return false;
        }
        if (this.isValidClassByteArray(classfileBuffer)) {
            this.logger.log(Level.FINER, "Skipping class {0}.  It does not appear to be a valid class file.", className);
            return false;
        }
        return loader != null || this.instrumentation.isBootstrapClassInstrumentationEnabled();
    }

    protected boolean isExcluded(String className) {
        return !this.classNameFilter.isIncluded(className) && this.classNameFilter.isExcluded(className);
    }

    private boolean isValidClassByteArray(byte[] classfileBuffer) {
        return classfileBuffer.length >= 4 && classfileBuffer[0] == -54 && classfileBuffer[0] == -2 && classfileBuffer[0] == -70 && classfileBuffer[0] == -66;
    }

    private boolean isAgentHandleValid() {
        if (this.agentHandleMethodExists) {
            return true;
        }
        try {
            Proxy.class.getMethod("getAgentHandle", new Class[0]);
            this.agentHandleMethodExists = true;
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected int getClassReaderFlags() {
        return this.classreaderFlags;
    }

    private WeavingLoaderImpl getWeavingLoader(ClassLoader loader) {
        return new WeavingLoaderImpl(loader);
    }

    public void clearJobQueue() {
        LatchingRunnable runnable = new LatchingRunnable();
        this.executor.execute(runnable);
        runnable.block();
    }

    protected void logDebug(Throwable e, String message) {
        if (this.debug) {
            this.logger.log(Level.FINER, message, e);
        }
    }

    public void shutdown() {
        List<Runnable> queuedJobs = this.executor.shutdownNow();
        if (this.debug && !queuedJobs.isEmpty()) {
            this.logger.log(Level.FINER, "Class transformer stopped with {0} job(s) queued", queuedJobs.size());
        }
    }

    InstrumentationProxy getInstrumentation() {
        return this.instrumentation;
    }

    public final ClassNameFilter getClassNameFilter() {
        return this.classNameFilter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeavingLoaderImpl {
        private final ClassLoader classLoader;

        public WeavingLoaderImpl(ClassLoader classLoader) {
            this.classLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        }

        public byte[] preProcess(String className, Class<?> classBeingRedefined, byte[] classfileBuffer) {
            boolean isInterface;
            InstrumentedClass annotation;
            if (classBeingRedefined != null && (annotation = classBeingRedefined.getAnnotation(InstrumentedClass.class)) != null) {
                return null;
            }
            ClassReader cr = new ClassReader(classfileBuffer);
            ClassWriter cw = new ClassWriter(cr, 1);
            boolean bl = isInterface = (cr.getAccess() & 0x200) != 0;
            if (isInterface) {
                return null;
            }
            Collection<PointCut> nonMatchers = this.getNonMatchingPointCuts(className, cr, cw, classBeingRedefined);
            LinkedList<PointCut> possibleMatches = new LinkedList<PointCut>(ClassTransformer.this.pointcuts);
            possibleMatches.removeAll(nonMatchers);
            if (possibleMatches.isEmpty() && !ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().isCustomTracingEnabled()) {
                return null;
            }
            Collection<PointCut> strongMatches = this.getMatchingPointCuts(possibleMatches, className, cr, cw, classBeingRedefined);
            possibleMatches.removeAll(strongMatches);
            if (classBeingRedefined != null && strongMatches.isEmpty()) {
                return null;
            }
            try {
                GenericClassAdapter adapter = new GenericClassAdapter(ClassTransformer.this.isAgentHandleValid(), cw, className, classBeingRedefined, strongMatches, possibleMatches);
                cr.accept(adapter, ClassTransformer.this.classreaderFlags);
                if (adapter.isStrongMatch()) {
                    ClassTransformer.this.logger.finest("Instrumented class " + className);
                    if (adapter.isWeakMatch()) {
                        this.queueClassLoad(className);
                    }
                    return cw.toByteArray();
                }
                if (!adapter.isWeakMatch()) {
                    return null;
                }
            }
            catch (StopProcessingException e) {
                return null;
            }
            catch (ArrayIndexOutOfBoundsException t) {
                ClassTransformer.this.logger.log(Level.SEVERE, "An ASM array bounds exception occurred transforming class {0} ({1} bytes) : {2}", new Object[]{className, classfileBuffer.length, t.toString()});
                ClassTransformer.this.logger.log(Level.INFO, "ASM error for pointcut(s) : strong {0} / weak {1}", new Object[]{strongMatches, possibleMatches});
                ClassTransformer.this.logger.log(Level.FINER, "ASM error", t);
                if (Boolean.getBoolean("newrelic.asm.error.stop")) {
                    System.exit(-1);
                }
                return null;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable t) {
                ClassTransformer.this.logger.severe(MessageFormat.format("An error occurred transforming class {0} : {1}", className, t.toString()));
                ClassTransformer.this.logger.log(Level.INFO, "Error transforming class " + className, t);
                return null;
            }
            if (classBeingRedefined == null) {
                if (ClassTransformer.this.retransformSupported) {
                    this.queueRetransformation(className);
                } else {
                    if (ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().isDebugEnabled()) {
                        ClassTransformer.this.logger.finer("Conditionally instrumenting class " + className);
                    }
                    this.queueClassLoad(className);
                    return cw.toByteArray();
                }
            }
            return null;
        }

        private Collection<PointCut> getMatchingPointCuts(Collection<PointCut> possibleMatches, String className, ClassReader cr, ClassWriter cw, Class<?> classBeingRedefined) {
            LinkedList<PointCut> cuts = new LinkedList<PointCut>();
            for (PointCut pc : possibleMatches) {
                if ((classBeingRedefined == null || !pc.getClassMatcher().isMatch(classBeingRedefined)) && !pc.getClassMatcher().isMatch(this.classLoader, className, cr)) continue;
                cuts.add(pc);
            }
            return cuts;
        }

        private Collection<PointCut> getNonMatchingPointCuts(String className, ClassReader cr, ClassWriter cw, Class<?> classBeingRedefined) {
            LinkedList<PointCut> cuts = new LinkedList<PointCut>();
            for (PointCut pc : ClassTransformer.this.pointcuts) {
                if (!pc.getClassMatcher().isNotMatch(this.classLoader, className, cr, classBeingRedefined)) continue;
                cuts.add(pc);
            }
            return cuts;
        }

        private void queueRedefinition(final String className, final byte[] classfileBuffer) {
            ClassTransformer.this.executor.execute(new Runnable(){

                public void run() {
                    WeavingLoaderImpl.this.redefineClass(className, classfileBuffer);
                }
            });
        }

        private synchronized void redefineClass(String className, byte[] classfileBuffer) {
            try {
                ClassTransformer.this.instrumentation.redefineClasses(new ClassDefinition[]{new ClassDefinition(this.classLoader.loadClass(Invoker.getClassNameFromInternalName(className)), classfileBuffer)});
            }
            catch (ClassNotFoundException e) {
                ClassTransformer.this.logDebug(e, "An error occurred redefining class " + className);
            }
            catch (UnmodifiableClassException e) {
                ClassTransformer.this.logDebug(e, e.toString());
            }
        }

        private void queueClassLoad(final String className) {
            ClassTransformer.this.executor.execute(new Runnable(){

                public void run() {
                    WeavingLoaderImpl.this.classLoaded(className);
                }
            });
        }

        private void queueRetransformation(String internalClassName) {
            final String className = Invoker.getClassNameFromInternalName(internalClassName);
            ClassTransformer.this.executor.execute(new Runnable(){
                boolean first = true;

                public void run() {
                    try {
                        if (this.first) {
                            Class<?> clazz = WeavingLoaderImpl.this.classLoader.loadClass(className);
                            WeavingLoaderImpl.this.retransform(clazz);
                            return;
                        }
                        WeavingLoaderImpl.this.requestRetransform(className);
                    }
                    catch (Throwable e) {
                        this.first = false;
                        ClassTransformer.this.executor.execute(this);
                    }
                }
            });
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        private void retransform(Class clazz) {
            if (ClassTransformer.this.instrumentation.isModifiableClass(clazz)) {
                try {
                    ClassTransformer.this.instrumentation.retransformClasses(clazz);
                }
                catch (UnmodifiableClassException unmodifiableClassException) {
                    // empty catch block
                }
            }
        }

        private synchronized void requestRetransform(String className) {
            try {
                Class<?> clazz = this.classLoader.loadClass(className);
                this.retransform(clazz);
            }
            catch (LinkageError e) {
                this.handleLinkageError(e);
            }
            catch (ClassNotFoundException e) {
                ClassTransformer.this.logger.log(this.getClassNotFoundLogLevel(className), "Unable to load class {0} for retransformation : {1}, {2}", new Object[]{className, this.classLoader, e.toString()});
            }
            catch (Throwable e) {
                ClassTransformer.this.logger.log(Level.SEVERE, "Unable to retransform class {0} : {1}", new Object[]{className, e.toString()});
                ClassTransformer.this.logger.log(Level.SEVERE, "Unable to retransform class", e);
            }
        }

        private Level getClassNotFoundLogLevel(String className) {
            return className.startsWith("$") || className.indexOf("$$") > 0 ? Level.FINE : Level.SEVERE;
        }

        synchronized void classLoaded(String className) {
            try {
                this.classLoaded(this.classLoader.loadClass(Invoker.getClassNameFromInternalName(className)));
            }
            catch (ClassNotFoundException e) {
                ClassTransformer.this.logger.log(this.getClassNotFoundLogLevel(className), "Unable to load class {0} for instrumentation second pass : {1}", new Object[]{className, e.toString()});
            }
            catch (LinkageError e) {
                this.handleLinkageError(e);
            }
            catch (Exception e) {
                ClassTransformer.this.logDebug(e, "An error occurred loading class " + className);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void classLoaded(Class clazz) {
            Class clazz2 = clazz;
            synchronized (clazz2) {
                HashSet<String> factoryNames = new HashSet<String>(this.getTracerFactories(clazz));
                if (factoryNames.isEmpty()) {
                    return;
                }
                ServiceManagerFactory.getServiceManager().getTracerService().registerClassTracerFactories(clazz, factoryNames);
                ClassTransformer.this.logger.log(Level.FINER, "Instrumenting {0} with tracer factories {1}", new Object[]{clazz.getName(), factoryNames});
            }
        }

        private Collection<String> getTracerFactories(Class clazz) {
            LinkedList<String> factories = new LinkedList<String>();
            for (PointCut pc : ClassTransformer.this.pointcuts) {
                if (!pc.getClassMatcher().isMatch(clazz)) continue;
                factories.add(pc.getTracerFactoryName());
            }
            return factories;
        }

        private void handleLinkageError(LinkageError e) {
            if (this.classLoader.getClass().getName().contains("jasper")) {
                return;
            }
            ClassTransformer.this.logDebug(e, "Linkage error: " + e.toString());
        }
    }
}

