/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.instrumentation.AbstractClassTransformer;
import com.newrelic.agent.instrumentation.ClassLoaderClassAdapter;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.ClassWriter;
import java.security.ProtectionDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassLoaderClassTransformer
extends AbstractClassTransformer {
    public ClassLoaderClassTransformer(int classreaderFlags) {
        super(classreaderFlags, ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().isCustomTracingEnabled());
    }

    @Override
    protected boolean isRetransformSupported() {
        return true;
    }

    @Override
    protected ClassVisitor getClassVisitor(ClassReader cr, ClassWriter cw, String className) {
        return new ClassLoaderClassAdapter(cw, className, cr.getSuperName());
    }

    @Override
    protected boolean matches(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        return ClassLoaderClassAdapter.matchesClass(className);
    }
}

