/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IAgent;
import com.newrelic.agent.MetricSpec;
import com.newrelic.agent.TracerService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentWrapper
implements InvocationHandler {
    public static final Object SUCCESSFUL_METHOD_INVOCATION = "s";
    public static final Object UNSUCCESSFUL_METHOD_INVOCATION = "u";
    private final TracerService tracerService = ServiceManagerFactory.getServiceManager().getTracerService();
    private final IAgent agent = ServiceManagerFactory.getServiceManager().getAgent();
    private final Logger logger = Agent.LOG.getChildLogger("com.newrelic.agent.InvocationHandler", "InvocationHandler");

    private AgentWrapper() {
    }

    public static AgentWrapper getAgentWrapper() {
        boolean debug = false;
        try {
            AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
            Map tracerConfig = config.getSupportabilityConfig().getProperty("tracers", Collections.emptyMap());
            if (tracerConfig != null) {
                Object val = tracerConfig.get("timing_enabled");
                debug = val != null && (Boolean)val != false;
            }
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINER, "Unable to read supportability config", t);
        }
        if (debug) {
            return new DebugAgentWrapper();
        }
        return new AgentWrapper();
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
        if (!this.agent.isEnabled()) {
            return null;
        }
        try {
            InvocationHandler tracer = this.getTracer((String)args[0], (String[])args[1], (String)args[2], (String)args[3], (String)args[4], args[5], (Object[])args[6]);
            if (this.logger.isLoggable(Level.FINEST)) {
                if (tracer != null) {
                    this.logger.log(Level.FINEST, "trace: {0}.{1}()", new Object[]{args[2], args[3]});
                } else {
                    this.logger.log(Level.FINEST, "no trace: {0}.{1}()", new Object[]{args[2], args[3]});
                }
            }
            return tracer;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            if (args == null) {
                this.logger.severe("Agent.getTracer() was invoked with no arguments");
            } else if (args.length != 7) {
                this.logger.log(Level.SEVERE, "Agent.getTracer() was invoked with an incorrect number of arguments ({0})", args.length);
            } else {
                this.logger.log(Level.SEVERE, "An error occurred fetching a method tracer: {0}", e.toString());
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Method tracer creation error.  Arguments: {0}", Arrays.asList(args));
                    this.logger.log(Level.FINER, e.toString(), e);
                }
            }
            return null;
        }
    }

    protected InvocationHandler getTracer(String tracerFactoryName, String[] possibleFactories, String className, String methodName, String methodDesc, Object object, Object[] args) {
        return this.tracerService.getTracer(tracerFactoryName, possibleFactories, className, methodName, methodDesc, object, args);
    }

    private static String getTracerMetricName(InvocationHandler tracer) {
        return "Supportability/Tracers/" + tracer.getClass().getName();
    }

    private static class DebugTracerWrapper
    implements InvocationHandler {
        private final InvocationHandler tracer;

        public DebugTracerWrapper(InvocationHandler tracer) {
            this.tracer = tracer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object obj, Method method, Object[] aobj) throws Throwable {
            long start = System.nanoTime();
            try {
                Object object = this.tracer.invoke(obj, method, aobj);
                return object;
            }
            finally {
                long duration = System.nanoTime() - start;
                String metric = AgentWrapper.getTracerMetricName(this.tracer);
                MetricSpec spec = MetricSpec.lookup(metric + "/finish");
                MetricSpec totalSpec = MetricSpec.lookup(metric);
                StatsEngine statsEngine = ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMService().getStatsEngine();
                Object object = statsEngine.getHarvestLock();
                synchronized (object) {
                    statsEngine.getResponseTimeStats(spec).recordResponseTime(duration, TimeUnit.NANOSECONDS);
                    statsEngine.getResponseTimeStats(totalSpec).recordResponseTime(duration, TimeUnit.NANOSECONDS);
                }
            }
        }
    }

    private static class DebugAgentWrapper
    extends AgentWrapper {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected InvocationHandler getTracer(String tracerFactoryName, String[] possibleFactories, String className, String methodName, String methodDesc, Object object, Object[] args) {
            DebugTracerWrapper debugTracerWrapper;
            block16: {
                InvocationHandler tracer;
                MetricSpec totalSpec;
                MetricSpec spec;
                long start;
                block14: {
                    block15: {
                        start = System.nanoTime();
                        spec = null;
                        totalSpec = null;
                        try {
                            tracer = super.getTracer(tracerFactoryName, possibleFactories, className, methodName, methodDesc, object, args);
                            if (tracer != null) {
                                String metric = AgentWrapper.getTracerMetricName(tracer);
                                spec = MetricSpec.lookup(metric + "/start");
                                totalSpec = MetricSpec.lookup(metric);
                            }
                            if (tracer != null) break block14;
                            debugTracerWrapper = null;
                            if (spec == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (spec != null) {
                                long duration = System.nanoTime() - start;
                                StatsEngine statsEngine = ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMService().getStatsEngine();
                                Object object2 = statsEngine.getHarvestLock();
                                synchronized (object2) {
                                    statsEngine.getResponseTimeStats(spec).recordResponseTime(duration, TimeUnit.NANOSECONDS);
                                    statsEngine.getResponseTimeStats(totalSpec).recordResponseTime(duration, TimeUnit.NANOSECONDS);
                                }
                            }
                            throw throwable;
                        }
                        long duration = System.nanoTime() - start;
                        StatsEngine statsEngine = ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMService().getStatsEngine();
                        Object object3 = statsEngine.getHarvestLock();
                        synchronized (object3) {
                            statsEngine.getResponseTimeStats(spec).recordResponseTime(duration, TimeUnit.NANOSECONDS);
                            statsEngine.getResponseTimeStats(totalSpec).recordResponseTime(duration, TimeUnit.NANOSECONDS);
                        }
                    }
                    return debugTracerWrapper;
                }
                debugTracerWrapper = new DebugTracerWrapper(tracer);
                if (spec == null) break block16;
                long duration = System.nanoTime() - start;
                StatsEngine statsEngine = ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMService().getStatsEngine();
                Object object4 = statsEngine.getHarvestLock();
                synchronized (object4) {
                    statsEngine.getResponseTimeStats(spec).recordResponseTime(duration, TimeUnit.NANOSECONDS);
                    statsEngine.getResponseTimeStats(totalSpec).recordResponseTime(duration, TimeUnit.NANOSECONDS);
                }
            }
            return debugTracerWrapper;
        }
    }
}

