/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.extension.ConfigurationConstruct;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.org.yaml.snakeyaml.Loader;
import com.newrelic.org.yaml.snakeyaml.Yaml;
import com.newrelic.org.yaml.snakeyaml.constructor.Constructor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionService
extends AbstractService {
    private final List<ConfigurationConstruct> constructs = new ArrayList<ConfigurationConstruct>();
    private final Map<String, Extension> extensions = new HashMap<String, Extension>();
    private Yaml yaml;

    public ExtensionService() {
        super(ExtensionService.class.getSimpleName());
    }

    public void addConstruct(ConfigurationConstruct construct) {
        this.constructs.add(construct);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public final Map<String, Extension> getExtensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    @Override
    protected void doStart() {
        if (this.isEnabled()) {
            ExtensionConstructor constructor = new ExtensionConstructor();
            Loader loader = new Loader(constructor);
            this.yaml = new Yaml(loader);
            this.initializeBuiltInExtensions();
            this.initializeCustomExtensions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeBuiltInExtensions() {
        URL jarUrl = AgentJarHelper.getAgentJarUrl();
        if (jarUrl == null) {
            this.getLogger().log(Level.SEVERE, "Unable to determine the agent jar url");
            return;
        }
        try {
            JarFile file = new JarFile(URLDecoder.decode(jarUrl.getFile(), "UTF-8"));
            Collection<JarEntry> entries = ExtensionService.getExtensions(file);
            for (JarEntry entry : entries) {
                InputStream iStream = null;
                try {
                    iStream = Agent.class.getResourceAsStream('/' + entry.getName());
                    if (iStream == null) continue;
                    this.readExtension(entry.getName(), iStream);
                }
                finally {
                    if (iStream == null) continue;
                    try {
                        iStream.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Unable to read extensions from the agent jar : {0}", e.toString());
            this.getLogger().log(Level.FINER, "Extensions error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCustomExtensions() {
        for (File file : this.findExtensionFiles()) {
            FileInputStream fileStream = null;
            try {
                fileStream = new FileInputStream(file);
                this.readExtension(file.getName(), fileStream);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Unable to read extension file \"{0}\" - {1}", new Object[]{file.getAbsolutePath(), e.toString()});
                this.getLogger().log(Level.FINER, "Extension error", e);
            }
            finally {
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private File[] findExtensionFiles() {
        File instrumentationDir = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig().getCustomExtensionsDirectory();
        if (instrumentationDir == null) {
            return new File[0];
        }
        FileFilter yamlFilter = new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName();
                String extension = "";
                if (name.contains(".")) {
                    extension = name.substring(name.lastIndexOf(46), name.length());
                }
                return extension.equals(".yml") || extension.equals(".yaml");
            }
        };
        return instrumentationDir.listFiles(yamlFilter);
    }

    private void readExtension(String name, InputStream stream) {
        if (this.yaml == null) {
            this.getLogger().log(Level.SEVERE, "The Yaml parser has not been initialized");
            return;
        }
        try {
            Object config = this.yaml.load(stream);
            if (config instanceof Map) {
                Extension extension = new Extension((Map)config);
                this.addExtension(extension);
            } else {
                this.getLogger().log(Level.SEVERE, "Invalid extension file {0}", name);
            }
        }
        catch (Throwable e) {
            this.getLogger().log(Level.SEVERE, "Invalid extension file {0} : {1}", new Object[]{name, e.toString()});
            this.getLogger().log(Level.FINER, "Extension error", e);
        }
    }

    void addExtension(Extension extension) {
        Extension existing = this.extensions.get(extension.getName());
        if (existing == null || existing.getVersionNumber() < extension.getVersionNumber()) {
            this.extensions.put(extension.getName(), extension);
        }
    }

    private static Collection<JarEntry> getExtensions(JarFile file) {
        ArrayList<JarEntry> list = new ArrayList<JarEntry>();
        Pattern pattern = Pattern.compile("^META-INF/extensions/(.*).yml$");
        Enumeration<JarEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!pattern.matcher(name).matches()) continue;
            list.add(entry);
        }
        return list;
    }

    @Override
    protected void doStop() {
        this.extensions.clear();
    }

    private class ExtensionConstructor
    extends Constructor {
        public ExtensionConstructor() {
            for (ConfigurationConstruct construct : ExtensionService.this.constructs) {
                this.yamlConstructors.put(construct.getName(), construct);
            }
        }
    }
}

