/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.util.StackTraces;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableError
extends TracedError {
    private final Throwable throwable;

    public ThrowableError(String frontendMetricName, Throwable error, String requestPath, Map<?, ?> errorParameters, long timestamp) {
        super(frontendMetricName, requestPath, errorParameters, timestamp);
        this.throwable = error;
    }

    @Override
    public String getMessage() {
        String message = this.throwable.getMessage();
        if (message == null || message.length() == 0) {
            return "Unknown";
        }
        return message;
    }

    @Override
    public String getExceptionClass() {
        return this.throwable.getClass().getName();
    }

    @Override
    public Collection<String> stackTrace() {
        ArrayList<String> stackTrace = new ArrayList<String>();
        Throwable t = this.throwable;
        boolean inner = false;
        while (t != null) {
            if (inner) {
                stackTrace.add(" ");
                stackTrace.add(" caused by " + t.toString());
            }
            stackTrace.addAll(StackTraces.stackTracesToStrings(t.getStackTrace()));
            t = t.equals(t.getCause()) ? null : t.getCause();
            inner = true;
        }
        return stackTrace;
    }

    public String toString() {
        return this.getMessage();
    }

    public int hashCode() {
        return this.throwable.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThrowableError other = (ThrowableError)obj;
        return this.throwable.equals(other.throwable);
    }
}

